/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AnnotationUtils {
    public static <A extends Annotation> boolean isPresent(Method method, Class<A> annotationClass) {
        Map<ElementType, List<A>> annotationsMap = AnnotationUtils.findAnnotations(method, annotationClass);
        return !annotationsMap.isEmpty();
    }

    public static <A extends Annotation> Map<ElementType, List<A>> findAnnotations(Method method, Class<A> annotationClass) {
        ElementType[] elementTypes;
        Retention retention = annotationClass.getAnnotation(Retention.class);
        RetentionPolicy retentionPolicy = retention.value();
        if (!RetentionPolicy.RUNTIME.equals((Object)retentionPolicy)) {
            return Collections.emptyMap();
        }
        LinkedHashMap annotationsMap = new LinkedHashMap();
        Target target = annotationClass.getAnnotation(Target.class);
        for (ElementType elementType : elementTypes = target.value()) {
            LinkedList<Annotation> annotationsList = new LinkedList<Annotation>();
            switch (elementType) {
                case PARAMETER: {
                    Annotation[][] parameterAnnotations;
                    Annotation[][] annotationArray = parameterAnnotations = method.getParameterAnnotations();
                    int n = annotationArray.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation[] annotations;
                        for (Annotation annotation : annotations = annotationArray[i]) {
                            if (!annotationClass.equals(annotation.annotationType())) continue;
                            annotationsList.add(annotation);
                        }
                    }
                    break;
                }
                case METHOD: {
                    Annotation annotation = org.springframework.core.annotation.AnnotationUtils.findAnnotation((Method)method, annotationClass);
                    if (annotation == null) break;
                    annotationsList.add(annotation);
                    break;
                }
                case TYPE: {
                    Class<?> beanType = method.getDeclaringClass();
                    Annotation annotation2 = org.springframework.core.annotation.AnnotationUtils.findAnnotation(beanType, annotationClass);
                    if (annotation2 == null) break;
                    annotationsList.add(annotation2);
                }
            }
            if (annotationsList.isEmpty()) continue;
            annotationsMap.put(elementType, annotationsList);
        }
        return Collections.unmodifiableMap(annotationsMap);
    }
}

