/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.web.method;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Repository
public class HandlerMethodRepository {
    private Map<Object, HandlerMethod> handlerMethodsCache = Collections.emptyMap();
    @Autowired(required=false)
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    @PostConstruct
    public void init() {
        if (this.requestMappingHandlerMapping != null) {
            Collection handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods().values();
            HashMap<HandlerMethod, HandlerMethod> handlerMethodsMap = new HashMap<HandlerMethod, HandlerMethod>(handlerMethods.size());
            for (HandlerMethod handlerMethod : handlerMethods) {
                handlerMethodsMap.put(handlerMethod, handlerMethod);
            }
            this.handlerMethodsCache = Collections.unmodifiableMap(handlerMethodsMap);
        }
    }

    public Collection<HandlerMethod> getHandlerMethods() {
        return this.handlerMethodsCache.values();
    }

    public HandlerMethod get(Object handler) {
        return this.handlerMethodsCache.get(handler);
    }
}

