/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.web.servlet.mvc.util;

import com.alibaba.spring.util.BeanUtils;
import com.alibaba.spring.web.util.WebUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.filter.RequestContextFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class WebMvcUtils {
    public static final String ABSTRACT_JSONP_RESPONSE_BODY_ADVICE_CLASS_NAME = "org.springframework.web.servlet.mvc.findWebApplicationContextMethod.annotation.AbstractJsonpResponseBodyAdvice";
    private static final boolean ABSTRACT_JSONP_RESPONSE_BODY_ADVICE_PRESENT = ClassUtils.isPresent((String)"org.springframework.web.servlet.mvc.findWebApplicationContextMethod.annotation.AbstractJsonpResponseBodyAdvice", (ClassLoader)WebMvcUtils.class.getClassLoader());
    private static final String REQUEST_MAPPING_HANDLER_MAPPING_CONTEXT_NAME = RequestMappingHandlerMapping.class.getName();
    private static final String INIT_PARAM_DELIMITERS = ",; \t\n";
    private static final Method findWebApplicationContextMethod = ReflectionUtils.findMethod(RequestContextUtils.class, (String)"findWebApplicationContext", (Class[])new Class[]{HttpServletRequest.class, ServletContext.class});

    public static boolean isControllerAdviceBeanType(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, ControllerAdvice.class) != null;
    }

    public static HttpServletRequest currentRequest() throws IllegalStateException {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            throw new IllegalStateException("Current web environment could not be in Servlet Container with Spring Web MVC , because " + DispatcherServlet.class.getName() + " or " + RequestContextFilter.class.getName() + " never be used !");
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        return servletRequestAttributes.getRequest();
    }

    public static WebApplicationContext getWebApplicationContext(HttpServletRequest request, ServletContext servletContext) {
        WebApplicationContext webApplicationContext = null;
        if (findWebApplicationContextMethod != null) {
            try {
                webApplicationContext = (WebApplicationContext)ReflectionUtils.invokeMethod((Method)findWebApplicationContextMethod, null, (Object[])new Object[]{request, servletContext});
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (webApplicationContext == null) {
            webApplicationContext = RequestContextUtils.getWebApplicationContext((ServletRequest)request, (ServletContext)servletContext);
        }
        return webApplicationContext;
    }

    public static WebApplicationContext getWebApplicationContext(HttpServletRequest request) {
        return WebMvcUtils.getWebApplicationContext(request, WebUtils.getServletContext(request));
    }

    public static WebApplicationContext currentWebApplicationContext() {
        return WebMvcUtils.getWebApplicationContext(WebMvcUtils.currentRequest());
    }

    public static RequestMappingHandlerMapping getRequestMappingHandlerMapping(HttpServletRequest request, ServletContext servletContext) {
        WebApplicationContext webApplicationContext = WebMvcUtils.getWebApplicationContext(request, servletContext);
        return WebMvcUtils.getRequestMappingHandlerMapping(webApplicationContext);
    }

    public static RequestMappingHandlerMapping getRequestMappingHandlerMapping(HttpServletRequest request) {
        return WebMvcUtils.getRequestMappingHandlerMapping(request, WebUtils.getServletContext(request));
    }

    public static RequestMappingHandlerMapping getRequestMappingHandlerMapping(WebApplicationContext webApplicationContext) {
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)BeanUtils.getOptionalBean((ListableBeanFactory)webApplicationContext, RequestMappingHandlerMapping.class);
        return requestMappingHandlerMapping;
    }

    public static ServletContext currentServletContext() throws IllegalStateException {
        HttpServletRequest request = WebMvcUtils.currentRequest();
        ServletContext servletContext = WebUtils.getServletContext(request);
        return servletContext;
    }

    protected static String appendInitParameter(String existedParameterValue, String ... parameterValues) {
        Object[] existedParameterValues = StringUtils.hasLength((String)existedParameterValue) ? existedParameterValue.split(INIT_PARAM_DELIMITERS) : new String[]{};
        ArrayList<Object> parameterValuesList = new ArrayList<Object>();
        if (!ObjectUtils.isEmpty((Object[])existedParameterValues)) {
            parameterValuesList.addAll(Arrays.asList(existedParameterValues));
        }
        parameterValuesList.addAll(Arrays.asList(parameterValues));
        String newParameterValue = StringUtils.arrayToDelimitedString((Object[])parameterValuesList.toArray(), (String)",");
        return newParameterValue;
    }

    public static void appendInitParameters(ServletContext servletContext, String parameterName, String ... parameterValues) {
        Assert.notNull((Object)servletContext);
        Assert.hasLength((String)parameterName);
        Assert.notNull((Object)parameterValues);
        String existedParameterValue = servletContext.getInitParameter(parameterName);
        String newParameterValue = WebMvcUtils.appendInitParameter(existedParameterValue, parameterValues);
        if (StringUtils.hasLength((String)newParameterValue)) {
            servletContext.setInitParameter(parameterName, newParameterValue);
        }
    }

    public static void appendGlobalInitializerClassInitParameter(ServletContext servletContext, Class<? extends ApplicationContextInitializer> contextInitializerClass) {
        String contextInitializerClassName = contextInitializerClass.getName();
        WebMvcUtils.appendInitParameters(servletContext, "globalInitializerClasses", contextInitializerClassName);
    }

    public static void appendContextInitializerClassInitParameter(ServletContext servletContext, Class<? extends ApplicationContextInitializer> contextInitializerClass) {
        String contextInitializerClassName = contextInitializerClass.getName();
        WebMvcUtils.appendInitParameters(servletContext, "contextInitializerClasses", contextInitializerClassName);
    }

    public static void appendFrameworkServletContextInitializerClassInitParameter(ServletContext servletContext, Class<? extends ApplicationContextInitializer> contextInitializerClass) {
        Collection<? extends ServletRegistration> servletRegistrations = WebUtils.findServletRegistrations(servletContext, FrameworkServlet.class).values();
        for (ServletRegistration servletRegistration : servletRegistrations) {
            String contextInitializerClassName = servletRegistration.getInitParameter("contextInitializerClasses");
            String newContextInitializerClassName = WebMvcUtils.appendInitParameter(contextInitializerClassName, contextInitializerClass.getName());
            servletRegistration.setInitParameter("contextInitializerClasses", newContextInitializerClassName);
        }
    }

    public static boolean isPageRenderRequest(ModelAndView modelAndView) {
        if (modelAndView != null) {
            String viewName = modelAndView.getViewName();
            return StringUtils.hasText((String)viewName);
        }
        return false;
    }
}

