/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.threadpool.agent.TtlTransformer;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlExecutorTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlForkJoinTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlPriorityBlockingQueueTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlTimerTaskTransformlet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public final class TtlAgent {
    private static volatile Map<String, String> kvs;
    private static volatile boolean ttlAgentLoaded;
    private static final String TTL_AGENT_ENABLE_TIMER_TASK_KEY = "ttl.agent.enable.timer.task";
    private static final String TTL_AGENT_DISABLE_INHERITABLE_FOR_THREAD_POOL = "ttl.agent.disable.inheritable.for.thread.pool";

    public static void premain(String agentArgs, @NonNull Instrumentation inst) {
        kvs = TtlAgent.splitCommaColonStringToKV(agentArgs);
        Logger.setLoggerImplType(TtlAgent.getLogImplTypeFromAgentArgs(kvs));
        Logger logger = Logger.getLogger(TtlAgent.class);
        try {
            logger.info("[TtlAgent.premain] begin, agentArgs: " + agentArgs + ", Instrumentation: " + inst);
            boolean disableInheritableForThreadPool = TtlAgent.isDisableInheritableForThreadPool();
            ArrayList<JavassistTransformlet> transformletList = new ArrayList<JavassistTransformlet>();
            transformletList.add(new TtlExecutorTransformlet(disableInheritableForThreadPool));
            transformletList.add(new TtlPriorityBlockingQueueTransformlet());
            transformletList.add(new TtlForkJoinTransformlet(disableInheritableForThreadPool));
            if (TtlAgent.isEnableTimerTask()) {
                transformletList.add(new TtlTimerTaskTransformlet());
            }
            TtlTransformer transformer = new TtlTransformer(transformletList);
            inst.addTransformer(transformer, true);
            logger.info("[TtlAgent.premain] addTransformer " + transformer.getClass() + " success");
            logger.info("[TtlAgent.premain] end");
            ttlAgentLoaded = true;
        }
        catch (Exception e) {
            String msg = "Fail to load TtlAgent , cause: " + e;
            logger.log(Level.SEVERE, msg, e);
            throw new IllegalStateException(msg, e);
        }
    }

    private static String getLogImplTypeFromAgentArgs(@NonNull Map<String, String> kvs) {
        return kvs.get("ttl.agent.logger");
    }

    public static boolean isTtlAgentLoaded() {
        return ttlAgentLoaded;
    }

    public static boolean isDisableInheritableForThreadPool() {
        return TtlAgent.isBooleanOptionSet(kvs, TTL_AGENT_DISABLE_INHERITABLE_FOR_THREAD_POOL, false);
    }

    public static boolean isEnableTimerTask() {
        return TtlAgent.isBooleanOptionSet(kvs, TTL_AGENT_ENABLE_TIMER_TASK_KEY, true);
    }

    private static boolean isBooleanOptionSet(@Nullable Map<String, String> kvs, @NonNull String key, boolean defaultValue) {
        if (null == kvs) {
            return defaultValue;
        }
        boolean containsKey = kvs.containsKey(key);
        if (!containsKey) {
            return defaultValue;
        }
        return !"false".equalsIgnoreCase(kvs.get(key));
    }

    @NonNull
    static Map<String, String> splitCommaColonStringToKV(@Nullable String commaColonString) {
        String[] splitKvArray;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (commaColonString == null || commaColonString.trim().length() == 0) {
            return ret;
        }
        for (String kvString : splitKvArray = commaColonString.trim().split("\\s*,\\s*")) {
            String[] kv = kvString.trim().split("\\s*:\\s*");
            if (kv.length == 0) continue;
            if (kv.length == 1) {
                ret.put(kv[0], "");
                continue;
            }
            ret.put(kv[0], kv[1]);
        }
        return ret;
    }

    private TtlAgent() {
        throw new InstantiationError("Must not instantiate this class");
    }

    static {
        ttlAgentLoaded = false;
    }
}

