/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.autoconfigure.ConfigTree;
import com.alicp.jetcache.autoconfigure.ExternalCacheAutoInit;
import com.alicp.jetcache.autoconfigure.JetCacheCondition;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redisson.RedissonCacheBuilder;
import java.util.Map;
import java.util.Objects;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={RedissonCondition.class})
public class RedissonAutoConfiguration {
    private static final String CACHE_TYPE = "redisson";

    @Bean
    public RedissonAutoInit redissonAutoInit() {
        return new RedissonAutoInit();
    }

    public static class RedissonAutoInit
    extends ExternalCacheAutoInit
    implements ApplicationContextAware {
        private ApplicationContext context;

        public RedissonAutoInit() {
            super(RedissonAutoConfiguration.CACHE_TYPE);
        }

        @Override
        protected CacheBuilder initCache(ConfigTree ct, String cacheAreaWithPrefix) {
            Map beans = this.context.getBeansOfType(RedissonClient.class);
            if (beans.isEmpty()) {
                throw new CacheConfigException("no RedissonClient in spring context");
            }
            RedissonClient client = (RedissonClient)beans.values().iterator().next();
            if (beans.size() > 1) {
                String redissonClientName = ct.getProperty("redissonClient");
                if (Objects.isNull(redissonClientName) || redissonClientName.isEmpty()) {
                    throw new CacheConfigException("redissonClient is required, because there is multiple RedissonClient in Spring context");
                }
                if (!beans.containsKey(redissonClientName)) {
                    throw new CacheConfigException("there is no RedissonClient named " + redissonClientName + " in Spring context");
                }
                client = (RedissonClient)beans.get(redissonClientName);
            }
            ExternalCacheBuilder builder = RedissonCacheBuilder.createBuilder().redissonClient(client);
            this.parseGeneralConfig((CacheBuilder)builder, ct);
            return builder;
        }

        public void setApplicationContext(ApplicationContext context) throws BeansException {
            this.context = context;
        }
    }

    public static class RedissonCondition
    extends JetCacheCondition {
        public RedissonCondition() {
            super(RedissonAutoConfiguration.CACHE_TYPE);
        }
    }
}

