/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.CacheMonitor;
import com.alicp.jetcache.LoadingCache;
import com.alicp.jetcache.RefreshCache;
import com.alicp.jetcache.RefreshPolicy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public abstract class AbstractCacheBuilder<T extends AbstractCacheBuilder<T>>
implements CacheBuilder,
Cloneable {
    protected CacheConfig config;
    private Function<CacheConfig, Cache> buildFunc;

    public abstract CacheConfig getConfig();

    protected T self() {
        return (T)this;
    }

    public T buildFunc(Function<CacheConfig, Cache> buildFunc) {
        this.buildFunc = buildFunc;
        return this.self();
    }

    protected void beforeBuild() {
    }

    @Deprecated
    public final <K, V> Cache<K, V> build() {
        return this.buildCache();
    }

    @Override
    public final <K, V> Cache<K, V> buildCache() {
        if (this.buildFunc == null) {
            throw new CacheConfigException("no buildFunc");
        }
        this.beforeBuild();
        CacheConfig c = this.getConfig().clone();
        LoadingCache cache = this.buildFunc.apply(c);
        if (c.getLoader() != null) {
            cache = c.getRefreshPolicy() == null ? new LoadingCache(cache) : new RefreshCache((Cache)cache);
        }
        return cache;
    }

    public Object clone() {
        AbstractCacheBuilder copy = null;
        try {
            copy = (AbstractCacheBuilder)super.clone();
            copy.config = this.getConfig().clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException(e);
        }
    }

    public T keyConvertor(Function<Object, Object> keyConvertor) {
        this.getConfig().setKeyConvertor(keyConvertor);
        return this.self();
    }

    public void setKeyConvertor(Function<Object, Object> keyConvertor) {
        this.getConfig().setKeyConvertor(keyConvertor);
    }

    public T expireAfterAccess(long defaultExpire, TimeUnit timeUnit) {
        this.getConfig().setExpireAfterAccessInMillis(timeUnit.toMillis(defaultExpire));
        return this.self();
    }

    public void setExpireAfterAccessInMillis(long expireAfterAccessInMillis) {
        this.getConfig().setExpireAfterAccessInMillis(expireAfterAccessInMillis);
    }

    public T expireAfterWrite(long defaultExpire, TimeUnit timeUnit) {
        this.getConfig().setExpireAfterWriteInMillis(timeUnit.toMillis(defaultExpire));
        return this.self();
    }

    public void setExpireAfterWriteInMillis(long expireAfterWriteInMillis) {
        this.getConfig().setExpireAfterWriteInMillis(expireAfterWriteInMillis);
    }

    public T addMonitor(CacheMonitor monitor) {
        this.getConfig().getMonitors().add(monitor);
        return this.self();
    }

    public void setMonitors(List<CacheMonitor> monitors) {
        this.getConfig().setMonitors(monitors);
    }

    public T cacheNullValue(boolean cacheNullValue) {
        this.getConfig().setCacheNullValue(cacheNullValue);
        return this.self();
    }

    public void setCacheNullValue(boolean cacheNullValue) {
        this.getConfig().setCacheNullValue(cacheNullValue);
    }

    public <K, V> T loader(CacheLoader<K, V> loader) {
        this.getConfig().setLoader(loader);
        return this.self();
    }

    public <K, V> void setLoader(CacheLoader<K, V> loader) {
        this.getConfig().setLoader(loader);
    }

    public T refreshPolicy(RefreshPolicy refreshPolicy) {
        this.getConfig().setRefreshPolicy(refreshPolicy);
        return this.self();
    }

    public void setRefreshPolicy(RefreshPolicy refreshPolicy) {
        this.getConfig().setRefreshPolicy(refreshPolicy);
    }

    public T cachePenetrateProtect(boolean cachePenetrateProtect) {
        this.getConfig().setCachePenetrationProtect(cachePenetrateProtect);
        return this.self();
    }

    public void setCachePenetrateProtect(boolean cachePenetrateProtect) {
        this.getConfig().setCachePenetrationProtect(cachePenetrateProtect);
    }
}

