/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class SquashedLogger {
    private static final int DEFAULT_INTERVAL_SECONDS = 10;
    private static final ConcurrentHashMap<Logger, SquashedLogger> MAP = new ConcurrentHashMap();
    private final Logger logger;
    private final long interval;
    private final AtomicLong lastLogTime;

    private SquashedLogger(Logger logger, int intervalSeconds) {
        this.logger = logger;
        this.interval = Duration.ofSeconds(intervalSeconds).toNanos();
        this.lastLogTime = new AtomicLong(System.nanoTime() - this.interval);
    }

    public static SquashedLogger getLogger(Logger target, int intervalSeconds) {
        SquashedLogger result = MAP.get(target);
        if (result == null) {
            result = MAP.computeIfAbsent(target, k -> new SquashedLogger((Logger)k, intervalSeconds));
        }
        return result;
    }

    public static SquashedLogger getLogger(Logger target) {
        return SquashedLogger.getLogger(target, 10);
    }

    private boolean shouldLogEx() {
        long last;
        long now = System.nanoTime();
        if (Math.abs(now - (last = this.lastLogTime.get())) >= this.interval) {
            return this.lastLogTime.compareAndSet(last, now);
        }
        return false;
    }

    public void error(CharSequence msg, Throwable e) {
        if (this.shouldLogEx()) {
            this.logger.error(msg.toString(), e);
        } else {
            StringBuilder sb;
            if (msg instanceof StringBuilder) {
                sb = (StringBuilder)msg;
            } else {
                sb = new StringBuilder(msg.length() + 256);
                sb.append(msg);
            }
            sb.append(' ');
            int i = 0;
            while (e != null && i++ < 20) {
                sb.append(e);
                if ((e = e.getCause()) == null) continue;
                sb.append("\ncause by ");
            }
            this.logger.error(sb.toString());
        }
    }
}

