/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dkms.gcs.openapi.credential.auth;

import com.aliyun.dkms.gcs.openapi.credential.auth.AlibabaCloudCredentials;
import com.aliyun.dkms.gcs.openapi.credential.auth.Signer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SHA256withRSASigner
extends Signer {
    public static final String ENCODING = "UTF-8";
    private static final String ALGORITHM_NAME = "RSA_PKCS1_SHA_256";
    private static final String PEM_PRIVATE_KEY_PREFIX_PKCS1 = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String PEM_PRIVATE_KEY_PREFIX_PKCS8 = "-----BEGIN PRIVATE KEY-----";
    private static final String PEM_PRIVATE_KEY_SUFFIX_PKCS1 = "-----END RSA PRIVATE KEY-----";
    private static final String PEM_PRIVATE_KEY_SUFFIX_PKCS8 = "-----END PRIVATE KEY-----";

    @Override
    public String signString(String stringToSign, String accessKeySecret) {
        try {
            byte[] pkcs8KeySpec;
            String privateKeyDer;
            Signature rsaSign = Signature.getInstance("SHA256withRSA");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            if (accessKeySecret.contains(PEM_PRIVATE_KEY_PREFIX_PKCS1) && accessKeySecret.contains(PEM_PRIVATE_KEY_SUFFIX_PKCS1)) {
                privateKeyDer = accessKeySecret.replace(PEM_PRIVATE_KEY_PREFIX_PKCS1, "").replaceAll("\r\n", "").replaceAll("\n", "").replace(PEM_PRIVATE_KEY_SUFFIX_PKCS1, "");
                byte[] keySpec = Base64.getDecoder().decode(privateKeyDer);
                pkcs8KeySpec = this.formatPkcs1ToPkcs8(keySpec);
            } else if (accessKeySecret.contains(PEM_PRIVATE_KEY_PREFIX_PKCS8) && accessKeySecret.contains(PEM_PRIVATE_KEY_SUFFIX_PKCS8)) {
                privateKeyDer = accessKeySecret.replace(PEM_PRIVATE_KEY_PREFIX_PKCS8, "").replaceAll("\r\n", "").replaceAll("\n", "").replace(PEM_PRIVATE_KEY_SUFFIX_PKCS8, "");
                pkcs8KeySpec = Base64.getDecoder().decode(privateKeyDer);
            } else {
                throw new IllegalArgumentException("Illegal private key pem format");
            }
            PrivateKey privateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(pkcs8KeySpec));
            rsaSign.initSign(privateKey);
            rsaSign.update(stringToSign.getBytes(ENCODING));
            byte[] sign = rsaSign.sign();
            return "Bearer " + Base64.getEncoder().encodeToString(sign);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Private key contains " + e.getMessage());
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public String signString(String stringToSign, AlibabaCloudCredentials credentials) {
        return this.signString(stringToSign, credentials.getAccessKeySecret());
    }

    @Override
    public String getSignerName() {
        return ALGORITHM_NAME;
    }

    @Override
    public String getSignerVersion() {
        return "1.0";
    }

    @Override
    public String getSignerType() {
        return "rsa_key_pair";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] formatPkcs1ToPkcs8(byte[] pkcs1PrivateKey) {
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(pkcs1PrivateKey);){
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
            ASN1Primitive asn1Object = asn1InputStream.readObject();
            PrivateKeyInfo privKeyInfo = new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)asn1Object);
            byte[] byArray = privKeyInfo.getEncoded();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}

