/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateChannelRequest
extends Request {
    @Query
    @NameInMap(value="AccessPolicy")
    private Boolean accessPolicy;
    @Query
    @NameInMap(value="AccessToken")
    private String accessToken;
    @Query
    @NameInMap(value="ChannelName")
    @Validation(required=true)
    private String channelName;
    @Query
    @NameInMap(value="ChannelTier")
    @Validation(required=true)
    private String channelTier;
    @Query
    @NameInMap(value="FillerSourceLocationName")
    private String fillerSourceLocationName;
    @Query
    @NameInMap(value="FillerSourceName")
    private String fillerSourceName;
    @Query
    @NameInMap(value="OutPutConfigList")
    @Validation(required=true)
    private String outPutConfigList;
    @Query
    @NameInMap(value="PlaybackMode")
    @Validation(required=true)
    private String playbackMode;

    private CreateChannelRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessPolicy = builder.accessPolicy;
        this.accessToken = builder.accessToken;
        this.channelName = builder.channelName;
        this.channelTier = builder.channelTier;
        this.fillerSourceLocationName = builder.fillerSourceLocationName;
        this.fillerSourceName = builder.fillerSourceName;
        this.outPutConfigList = builder.outPutConfigList;
        this.playbackMode = builder.playbackMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateChannelRequest create() {
        return CreateChannelRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Boolean getAccessPolicy() {
        return this.accessPolicy;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getChannelTier() {
        return this.channelTier;
    }

    public String getFillerSourceLocationName() {
        return this.fillerSourceLocationName;
    }

    public String getFillerSourceName() {
        return this.fillerSourceName;
    }

    public String getOutPutConfigList() {
        return this.outPutConfigList;
    }

    public String getPlaybackMode() {
        return this.playbackMode;
    }

    public static final class Builder
    extends Request.Builder<CreateChannelRequest, Builder> {
        private Boolean accessPolicy;
        private String accessToken;
        private String channelName;
        private String channelTier;
        private String fillerSourceLocationName;
        private String fillerSourceName;
        private String outPutConfigList;
        private String playbackMode;

        private Builder() {
        }

        private Builder(CreateChannelRequest request) {
            super((Request)request);
            this.accessPolicy = request.accessPolicy;
            this.accessToken = request.accessToken;
            this.channelName = request.channelName;
            this.channelTier = request.channelTier;
            this.fillerSourceLocationName = request.fillerSourceLocationName;
            this.fillerSourceName = request.fillerSourceName;
            this.outPutConfigList = request.outPutConfigList;
            this.playbackMode = request.playbackMode;
        }

        public Builder accessPolicy(Boolean accessPolicy) {
            this.putQueryParameter("AccessPolicy", accessPolicy);
            this.accessPolicy = accessPolicy;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("AccessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder channelName(String channelName) {
            this.putQueryParameter("ChannelName", channelName);
            this.channelName = channelName;
            return this;
        }

        public Builder channelTier(String channelTier) {
            this.putQueryParameter("ChannelTier", channelTier);
            this.channelTier = channelTier;
            return this;
        }

        public Builder fillerSourceLocationName(String fillerSourceLocationName) {
            this.putQueryParameter("FillerSourceLocationName", fillerSourceLocationName);
            this.fillerSourceLocationName = fillerSourceLocationName;
            return this;
        }

        public Builder fillerSourceName(String fillerSourceName) {
            this.putQueryParameter("FillerSourceName", fillerSourceName);
            this.fillerSourceName = fillerSourceName;
            return this;
        }

        public Builder outPutConfigList(String outPutConfigList) {
            this.putQueryParameter("OutPutConfigList", outPutConfigList);
            this.outPutConfigList = outPutConfigList;
            return this;
        }

        public Builder playbackMode(String playbackMode) {
            this.putQueryParameter("PlaybackMode", playbackMode);
            this.playbackMode = playbackMode;
            return this;
        }

        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }
    }
}

