/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import com.aliyun.sdk.service.ice20201109.models.Hotword;
import java.util.List;

public class CreateHotwordLibraryRequest
extends Request {
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="Hotwords")
    @Validation(required=true)
    private List<Hotword> hotwords;
    @Query
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Query
    @NameInMap(value="UsageScenario")
    @Validation(required=true)
    private String usageScenario;

    private CreateHotwordLibraryRequest(Builder builder) {
        super((Request.Builder)builder);
        this.description = builder.description;
        this.hotwords = builder.hotwords;
        this.name = builder.name;
        this.usageScenario = builder.usageScenario;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateHotwordLibraryRequest create() {
        return CreateHotwordLibraryRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDescription() {
        return this.description;
    }

    public List<Hotword> getHotwords() {
        return this.hotwords;
    }

    public String getName() {
        return this.name;
    }

    public String getUsageScenario() {
        return this.usageScenario;
    }

    public static final class Builder
    extends Request.Builder<CreateHotwordLibraryRequest, Builder> {
        private String description;
        private List<Hotword> hotwords;
        private String name;
        private String usageScenario;

        private Builder() {
        }

        private Builder(CreateHotwordLibraryRequest request) {
            super((Request)request);
            this.description = request.description;
            this.hotwords = request.hotwords;
            this.name = request.name;
            this.usageScenario = request.usageScenario;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder hotwords(List<Hotword> hotwords) {
            String hotwordsShrink = this.shrink(hotwords, "Hotwords", "json");
            this.putQueryParameter("Hotwords", hotwordsShrink);
            this.hotwords = hotwords;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder usageScenario(String usageScenario) {
            this.putQueryParameter("UsageScenario", usageScenario);
            this.usageScenario = usageScenario;
            return this;
        }

        public CreateHotwordLibraryRequest build() {
            return new CreateHotwordLibraryRequest(this);
        }
    }
}

