/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateMediaLiveInputRequest
extends Request {
    @Body
    @NameInMap(value="InputSettings")
    @Validation(required=true)
    private List<InputSettings> inputSettings;
    @Body
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Body
    @NameInMap(value="SecurityGroupIds")
    private List<String> securityGroupIds;
    @Body
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;

    private CreateMediaLiveInputRequest(Builder builder) {
        super((Request.Builder)builder);
        this.inputSettings = builder.inputSettings;
        this.name = builder.name;
        this.securityGroupIds = builder.securityGroupIds;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateMediaLiveInputRequest create() {
        return CreateMediaLiveInputRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<InputSettings> getInputSettings() {
        return this.inputSettings;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public String getType() {
        return this.type;
    }

    public static class InputSettings
    extends TeaModel {
        @NameInMap(value="FlowId")
        private String flowId;
        @NameInMap(value="FlowOutputName")
        private String flowOutputName;
        @NameInMap(value="SourceUrl")
        private String sourceUrl;
        @NameInMap(value="SrtLatency")
        private Integer srtLatency;
        @NameInMap(value="SrtMaxBitrate")
        private Integer srtMaxBitrate;
        @NameInMap(value="SrtPassphrase")
        private String srtPassphrase;
        @NameInMap(value="SrtPbKeyLen")
        private Integer srtPbKeyLen;
        @NameInMap(value="StreamName")
        private String streamName;

        private InputSettings(Builder builder) {
            this.flowId = builder.flowId;
            this.flowOutputName = builder.flowOutputName;
            this.sourceUrl = builder.sourceUrl;
            this.srtLatency = builder.srtLatency;
            this.srtMaxBitrate = builder.srtMaxBitrate;
            this.srtPassphrase = builder.srtPassphrase;
            this.srtPbKeyLen = builder.srtPbKeyLen;
            this.streamName = builder.streamName;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static InputSettings create() {
            return InputSettings.builder().build();
        }

        public String getFlowId() {
            return this.flowId;
        }

        public String getFlowOutputName() {
            return this.flowOutputName;
        }

        public String getSourceUrl() {
            return this.sourceUrl;
        }

        public Integer getSrtLatency() {
            return this.srtLatency;
        }

        public Integer getSrtMaxBitrate() {
            return this.srtMaxBitrate;
        }

        public String getSrtPassphrase() {
            return this.srtPassphrase;
        }

        public Integer getSrtPbKeyLen() {
            return this.srtPbKeyLen;
        }

        public String getStreamName() {
            return this.streamName;
        }

        public static final class Builder {
            private String flowId;
            private String flowOutputName;
            private String sourceUrl;
            private Integer srtLatency;
            private Integer srtMaxBitrate;
            private String srtPassphrase;
            private Integer srtPbKeyLen;
            private String streamName;

            private Builder() {
            }

            private Builder(InputSettings model) {
                this.flowId = model.flowId;
                this.flowOutputName = model.flowOutputName;
                this.sourceUrl = model.sourceUrl;
                this.srtLatency = model.srtLatency;
                this.srtMaxBitrate = model.srtMaxBitrate;
                this.srtPassphrase = model.srtPassphrase;
                this.srtPbKeyLen = model.srtPbKeyLen;
                this.streamName = model.streamName;
            }

            public Builder flowId(String flowId) {
                this.flowId = flowId;
                return this;
            }

            public Builder flowOutputName(String flowOutputName) {
                this.flowOutputName = flowOutputName;
                return this;
            }

            public Builder sourceUrl(String sourceUrl) {
                this.sourceUrl = sourceUrl;
                return this;
            }

            public Builder srtLatency(Integer srtLatency) {
                this.srtLatency = srtLatency;
                return this;
            }

            public Builder srtMaxBitrate(Integer srtMaxBitrate) {
                this.srtMaxBitrate = srtMaxBitrate;
                return this;
            }

            public Builder srtPassphrase(String srtPassphrase) {
                this.srtPassphrase = srtPassphrase;
                return this;
            }

            public Builder srtPbKeyLen(Integer srtPbKeyLen) {
                this.srtPbKeyLen = srtPbKeyLen;
                return this;
            }

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public InputSettings build() {
                return new InputSettings(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateMediaLiveInputRequest, Builder> {
        private List<InputSettings> inputSettings;
        private String name;
        private List<String> securityGroupIds;
        private String type;

        private Builder() {
        }

        private Builder(CreateMediaLiveInputRequest request) {
            super((Request)request);
            this.inputSettings = request.inputSettings;
            this.name = request.name;
            this.securityGroupIds = request.securityGroupIds;
            this.type = request.type;
        }

        public Builder inputSettings(List<InputSettings> inputSettings) {
            String inputSettingsShrink = this.shrink(inputSettings, "InputSettings", "json");
            this.putBodyParameter("InputSettings", inputSettingsShrink);
            this.inputSettings = inputSettings;
            return this;
        }

        public Builder name(String name) {
            this.putBodyParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            String securityGroupIdsShrink = this.shrink(securityGroupIds, "SecurityGroupIds", "json");
            this.putBodyParameter("SecurityGroupIds", securityGroupIdsShrink);
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        public Builder type(String type) {
            this.putBodyParameter("Type", type);
            this.type = type;
            return this;
        }

        public CreateMediaLiveInputRequest build() {
            return new CreateMediaLiveInputRequest(this);
        }
    }
}

