/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class GetSourceRequest
extends Request {
    @Query
    @NameInMap(value="SourceLocationName")
    @Validation(required=true)
    private String sourceLocationName;
    @Query
    @NameInMap(value="SourceName")
    @Validation(required=true)
    private String sourceName;
    @Query
    @NameInMap(value="SourceType")
    @Validation(required=true)
    private String sourceType;

    private GetSourceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.sourceLocationName = builder.sourceLocationName;
        this.sourceName = builder.sourceName;
        this.sourceType = builder.sourceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetSourceRequest create() {
        return GetSourceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getSourceLocationName() {
        return this.sourceLocationName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public static final class Builder
    extends Request.Builder<GetSourceRequest, Builder> {
        private String sourceLocationName;
        private String sourceName;
        private String sourceType;

        private Builder() {
        }

        private Builder(GetSourceRequest request) {
            super((Request)request);
            this.sourceLocationName = request.sourceLocationName;
            this.sourceName = request.sourceName;
            this.sourceType = request.sourceType;
        }

        public Builder sourceLocationName(String sourceLocationName) {
            this.putQueryParameter("SourceLocationName", sourceLocationName);
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.putQueryParameter("SourceName", sourceName);
            this.sourceName = sourceName;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.putQueryParameter("SourceType", sourceType);
            this.sourceType = sourceType;
            return this;
        }

        public GetSourceRequest build() {
            return new GetSourceRequest(this);
        }
    }
}

