/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class ListLiveRecordTemplatesRequest
extends Request {
    @Query
    @NameInMap(value="Keyword")
    private String keyword;
    @Query
    @NameInMap(value="PageNo")
    private Long pageNo;
    @Query
    @NameInMap(value="PageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;
    @Query
    @NameInMap(value="TemplateIds")
    private List<String> templateIds;
    @Query
    @NameInMap(value="Type")
    private String type;

    private ListLiveRecordTemplatesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.keyword = builder.keyword;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.sortBy = builder.sortBy;
        this.templateIds = builder.templateIds;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListLiveRecordTemplatesRequest create() {
        return ListLiveRecordTemplatesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Long getPageNo() {
        return this.pageNo;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public List<String> getTemplateIds() {
        return this.templateIds;
    }

    public String getType() {
        return this.type;
    }

    public static final class Builder
    extends Request.Builder<ListLiveRecordTemplatesRequest, Builder> {
        private String keyword;
        private Long pageNo;
        private Long pageSize;
        private String sortBy;
        private List<String> templateIds;
        private String type;

        private Builder() {
        }

        private Builder(ListLiveRecordTemplatesRequest request) {
            super((Request)request);
            this.keyword = request.keyword;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.sortBy = request.sortBy;
            this.templateIds = request.templateIds;
            this.type = request.type;
        }

        public Builder keyword(String keyword) {
            this.putQueryParameter("Keyword", keyword);
            this.keyword = keyword;
            return this;
        }

        public Builder pageNo(Long pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public Builder templateIds(List<String> templateIds) {
            this.putQueryParameter("TemplateIds", templateIds);
            this.templateIds = templateIds;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public ListLiveRecordTemplatesRequest build() {
            return new ListLiveRecordTemplatesRequest(this);
        }
    }
}

