/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListVodPackagingAssetsRequest
extends Request {
    @Query
    @NameInMap(value="GroupName")
    private String groupName;
    @Query
    @NameInMap(value="Keyword")
    private String keyword;
    @Query
    @NameInMap(value="PageNo")
    private Integer pageNo;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;

    private ListVodPackagingAssetsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.groupName = builder.groupName;
        this.keyword = builder.keyword;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.sortBy = builder.sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListVodPackagingAssetsRequest create() {
        return ListVodPackagingAssetsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public static final class Builder
    extends Request.Builder<ListVodPackagingAssetsRequest, Builder> {
        private String groupName;
        private String keyword;
        private Integer pageNo;
        private Integer pageSize;
        private String sortBy;

        private Builder() {
        }

        private Builder(ListVodPackagingAssetsRequest request) {
            super((Request)request);
            this.groupName = request.groupName;
            this.keyword = request.keyword;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.sortBy = request.sortBy;
        }

        public Builder groupName(String groupName) {
            this.putQueryParameter("GroupName", groupName);
            this.groupName = groupName;
            return this;
        }

        public Builder keyword(String keyword) {
            this.putQueryParameter("Keyword", keyword);
            this.keyword = keyword;
            return this;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public ListVodPackagingAssetsRequest build() {
            return new ListVodPackagingAssetsRequest(this);
        }
    }
}

