/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.sdk.service.ice20201109.models.LiveManifestConfig;
import darabonba.core.TeaModel;
import java.util.List;

public class LivePackagingConfig
extends TeaModel {
    @NameInMap(value="DrmConfig")
    private DrmConfig drmConfig;
    @NameInMap(value="LiveManifestConfigs")
    private List<LiveManifestConfig> liveManifestConfigs;
    @NameInMap(value="SegmentDuration")
    private Integer segmentDuration;
    @NameInMap(value="UseAudioRenditionGroups")
    private Boolean useAudioRenditionGroups;

    private LivePackagingConfig(Builder builder) {
        this.drmConfig = builder.drmConfig;
        this.liveManifestConfigs = builder.liveManifestConfigs;
        this.segmentDuration = builder.segmentDuration;
        this.useAudioRenditionGroups = builder.useAudioRenditionGroups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LivePackagingConfig create() {
        return LivePackagingConfig.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public DrmConfig getDrmConfig() {
        return this.drmConfig;
    }

    public List<LiveManifestConfig> getLiveManifestConfigs() {
        return this.liveManifestConfigs;
    }

    public Integer getSegmentDuration() {
        return this.segmentDuration;
    }

    public Boolean getUseAudioRenditionGroups() {
        return this.useAudioRenditionGroups;
    }

    public static class DrmConfig
    extends TeaModel {
        @NameInMap(value="ContentId")
        private String contentId;
        @NameInMap(value="EncryptionMethod")
        private String encryptionMethod;
        @NameInMap(value="IV")
        private String iv;
        @NameInMap(value="RotatePeriod")
        private Integer rotatePeriod;
        @NameInMap(value="SystemIds")
        private List<String> systemIds;
        @NameInMap(value="Url")
        private String url;

        private DrmConfig(Builder builder) {
            this.contentId = builder.contentId;
            this.encryptionMethod = builder.encryptionMethod;
            this.iv = builder.iv;
            this.rotatePeriod = builder.rotatePeriod;
            this.systemIds = builder.systemIds;
            this.url = builder.url;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DrmConfig create() {
            return DrmConfig.builder().build();
        }

        public String getContentId() {
            return this.contentId;
        }

        public String getEncryptionMethod() {
            return this.encryptionMethod;
        }

        public String getIv() {
            return this.iv;
        }

        public Integer getRotatePeriod() {
            return this.rotatePeriod;
        }

        public List<String> getSystemIds() {
            return this.systemIds;
        }

        public String getUrl() {
            return this.url;
        }

        public static final class Builder {
            private String contentId;
            private String encryptionMethod;
            private String iv;
            private Integer rotatePeriod;
            private List<String> systemIds;
            private String url;

            private Builder() {
            }

            private Builder(DrmConfig model) {
                this.contentId = model.contentId;
                this.encryptionMethod = model.encryptionMethod;
                this.iv = model.iv;
                this.rotatePeriod = model.rotatePeriod;
                this.systemIds = model.systemIds;
                this.url = model.url;
            }

            public Builder contentId(String contentId) {
                this.contentId = contentId;
                return this;
            }

            public Builder encryptionMethod(String encryptionMethod) {
                this.encryptionMethod = encryptionMethod;
                return this;
            }

            public Builder iv(String iv) {
                this.iv = iv;
                return this;
            }

            public Builder rotatePeriod(Integer rotatePeriod) {
                this.rotatePeriod = rotatePeriod;
                return this;
            }

            public Builder systemIds(List<String> systemIds) {
                this.systemIds = systemIds;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public DrmConfig build() {
                return new DrmConfig(this);
            }
        }
    }

    public static final class Builder {
        private DrmConfig drmConfig;
        private List<LiveManifestConfig> liveManifestConfigs;
        private Integer segmentDuration;
        private Boolean useAudioRenditionGroups;

        private Builder() {
        }

        private Builder(LivePackagingConfig model) {
            this.drmConfig = model.drmConfig;
            this.liveManifestConfigs = model.liveManifestConfigs;
            this.segmentDuration = model.segmentDuration;
            this.useAudioRenditionGroups = model.useAudioRenditionGroups;
        }

        public Builder drmConfig(DrmConfig drmConfig) {
            this.drmConfig = drmConfig;
            return this;
        }

        public Builder liveManifestConfigs(List<LiveManifestConfig> liveManifestConfigs) {
            this.liveManifestConfigs = liveManifestConfigs;
            return this;
        }

        public Builder segmentDuration(Integer segmentDuration) {
            this.segmentDuration = segmentDuration;
            return this;
        }

        public Builder useAudioRenditionGroups(Boolean useAudioRenditionGroups) {
            this.useAudioRenditionGroups = useAudioRenditionGroups;
            return this;
        }

        public LivePackagingConfig build() {
            return new LivePackagingConfig(this);
        }
    }
}

