/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;

public class StartRtcRobotInstanceRequest
extends Request {
    @Query
    @NameInMap(value="AuthToken")
    @Validation(required=true)
    private String authToken;
    @Query
    @NameInMap(value="ChannelId")
    @Validation(required=true)
    private String channelId;
    @Query
    @NameInMap(value="Config")
    private Config config;
    @Query
    @NameInMap(value="RobotId")
    @Validation(required=true)
    private String robotId;
    @Query
    @NameInMap(value="UserData")
    private String userData;
    @Query
    @NameInMap(value="UserId")
    @Validation(required=true)
    private String userId;

    private StartRtcRobotInstanceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.authToken = builder.authToken;
        this.channelId = builder.channelId;
        this.config = builder.config;
        this.robotId = builder.robotId;
        this.userData = builder.userData;
        this.userId = builder.userId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StartRtcRobotInstanceRequest create() {
        return StartRtcRobotInstanceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getRobotId() {
        return this.robotId;
    }

    public String getUserData() {
        return this.userData;
    }

    public String getUserId() {
        return this.userId;
    }

    public static class Config
    extends TeaModel {
        @NameInMap(value="AsrMaxSilence")
        private Integer asrMaxSilence;
        @NameInMap(value="EnableVoiceInterrupt")
        private Boolean enableVoiceInterrupt;
        @NameInMap(value="Greeting")
        private String greeting;
        @NameInMap(value="UseVoiceprint")
        private Boolean useVoiceprint;
        @NameInMap(value="UserOfflineTimeout")
        private Integer userOfflineTimeout;
        @NameInMap(value="UserOnlineTimeout")
        private Integer userOnlineTimeout;
        @NameInMap(value="VoiceId")
        private String voiceId;
        @NameInMap(value="VoiceprintId")
        private String voiceprintId;
        @NameInMap(value="Volume")
        private Long volume;

        private Config(Builder builder) {
            this.asrMaxSilence = builder.asrMaxSilence;
            this.enableVoiceInterrupt = builder.enableVoiceInterrupt;
            this.greeting = builder.greeting;
            this.useVoiceprint = builder.useVoiceprint;
            this.userOfflineTimeout = builder.userOfflineTimeout;
            this.userOnlineTimeout = builder.userOnlineTimeout;
            this.voiceId = builder.voiceId;
            this.voiceprintId = builder.voiceprintId;
            this.volume = builder.volume;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Config create() {
            return Config.builder().build();
        }

        public Integer getAsrMaxSilence() {
            return this.asrMaxSilence;
        }

        public Boolean getEnableVoiceInterrupt() {
            return this.enableVoiceInterrupt;
        }

        public String getGreeting() {
            return this.greeting;
        }

        public Boolean getUseVoiceprint() {
            return this.useVoiceprint;
        }

        public Integer getUserOfflineTimeout() {
            return this.userOfflineTimeout;
        }

        public Integer getUserOnlineTimeout() {
            return this.userOnlineTimeout;
        }

        public String getVoiceId() {
            return this.voiceId;
        }

        public String getVoiceprintId() {
            return this.voiceprintId;
        }

        public Long getVolume() {
            return this.volume;
        }

        public static final class Builder {
            private Integer asrMaxSilence;
            private Boolean enableVoiceInterrupt;
            private String greeting;
            private Boolean useVoiceprint;
            private Integer userOfflineTimeout;
            private Integer userOnlineTimeout;
            private String voiceId;
            private String voiceprintId;
            private Long volume;

            private Builder() {
            }

            private Builder(Config model) {
                this.asrMaxSilence = model.asrMaxSilence;
                this.enableVoiceInterrupt = model.enableVoiceInterrupt;
                this.greeting = model.greeting;
                this.useVoiceprint = model.useVoiceprint;
                this.userOfflineTimeout = model.userOfflineTimeout;
                this.userOnlineTimeout = model.userOnlineTimeout;
                this.voiceId = model.voiceId;
                this.voiceprintId = model.voiceprintId;
                this.volume = model.volume;
            }

            public Builder asrMaxSilence(Integer asrMaxSilence) {
                this.asrMaxSilence = asrMaxSilence;
                return this;
            }

            public Builder enableVoiceInterrupt(Boolean enableVoiceInterrupt) {
                this.enableVoiceInterrupt = enableVoiceInterrupt;
                return this;
            }

            public Builder greeting(String greeting) {
                this.greeting = greeting;
                return this;
            }

            public Builder useVoiceprint(Boolean useVoiceprint) {
                this.useVoiceprint = useVoiceprint;
                return this;
            }

            public Builder userOfflineTimeout(Integer userOfflineTimeout) {
                this.userOfflineTimeout = userOfflineTimeout;
                return this;
            }

            public Builder userOnlineTimeout(Integer userOnlineTimeout) {
                this.userOnlineTimeout = userOnlineTimeout;
                return this;
            }

            public Builder voiceId(String voiceId) {
                this.voiceId = voiceId;
                return this;
            }

            public Builder voiceprintId(String voiceprintId) {
                this.voiceprintId = voiceprintId;
                return this;
            }

            public Builder volume(Long volume) {
                this.volume = volume;
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<StartRtcRobotInstanceRequest, Builder> {
        private String authToken;
        private String channelId;
        private Config config;
        private String robotId;
        private String userData;
        private String userId;

        private Builder() {
        }

        private Builder(StartRtcRobotInstanceRequest request) {
            super((Request)request);
            this.authToken = request.authToken;
            this.channelId = request.channelId;
            this.config = request.config;
            this.robotId = request.robotId;
            this.userData = request.userData;
            this.userId = request.userId;
        }

        public Builder authToken(String authToken) {
            this.putQueryParameter("AuthToken", authToken);
            this.authToken = authToken;
            return this;
        }

        public Builder channelId(String channelId) {
            this.putQueryParameter("ChannelId", channelId);
            this.channelId = channelId;
            return this;
        }

        public Builder config(Config config) {
            String configShrink = this.shrink((Object)config, "Config", "json");
            this.putQueryParameter("Config", configShrink);
            this.config = config;
            return this;
        }

        public Builder robotId(String robotId) {
            this.putQueryParameter("RobotId", robotId);
            this.robotId = robotId;
            return this;
        }

        public Builder userData(String userData) {
            this.putQueryParameter("UserData", userData);
            this.userData = userData;
            return this;
        }

        public Builder userId(String userId) {
            this.putQueryParameter("UserId", userId);
            this.userId = userId;
            return this;
        }

        public StartRtcRobotInstanceRequest build() {
            return new StartRtcRobotInstanceRequest(this);
        }
    }
}

