/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import com.aliyun.sdk.service.ice20201109.models.Hotword;
import java.util.List;

public class UpdateHotwordLibraryRequest
extends Request {
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="HotwordLibraryId")
    @Validation(required=true)
    private String hotwordLibraryId;
    @Query
    @NameInMap(value="Hotwords")
    private List<Hotword> hotwords;
    @Query
    @NameInMap(value="Name")
    private String name;

    private UpdateHotwordLibraryRequest(Builder builder) {
        super((Request.Builder)builder);
        this.description = builder.description;
        this.hotwordLibraryId = builder.hotwordLibraryId;
        this.hotwords = builder.hotwords;
        this.name = builder.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateHotwordLibraryRequest create() {
        return UpdateHotwordLibraryRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getHotwordLibraryId() {
        return this.hotwordLibraryId;
    }

    public List<Hotword> getHotwords() {
        return this.hotwords;
    }

    public String getName() {
        return this.name;
    }

    public static final class Builder
    extends Request.Builder<UpdateHotwordLibraryRequest, Builder> {
        private String description;
        private String hotwordLibraryId;
        private List<Hotword> hotwords;
        private String name;

        private Builder() {
        }

        private Builder(UpdateHotwordLibraryRequest request) {
            super((Request)request);
            this.description = request.description;
            this.hotwordLibraryId = request.hotwordLibraryId;
            this.hotwords = request.hotwords;
            this.name = request.name;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder hotwordLibraryId(String hotwordLibraryId) {
            this.putQueryParameter("HotwordLibraryId", hotwordLibraryId);
            this.hotwordLibraryId = hotwordLibraryId;
            return this;
        }

        public Builder hotwords(List<Hotword> hotwords) {
            String hotwordsShrink = this.shrink(hotwords, "Hotwords", "json");
            this.putQueryParameter("Hotwords", hotwordsShrink);
            this.hotwords = hotwords;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public UpdateHotwordLibraryRequest build() {
            return new UpdateHotwordLibraryRequest(this);
        }
    }
}

