/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;

public class UpdateLiveTranscodeJobRequest
extends Request {
    @Query
    @NameInMap(value="JobId")
    @Validation(required=true)
    private String jobId;
    @Query
    @NameInMap(value="Name")
    @Validation(maxLength=128, minLength=1)
    private String name;
    @Query
    @NameInMap(value="StreamInput")
    private StreamInput streamInput;
    @Query
    @NameInMap(value="TimedConfig")
    private TimedConfig timedConfig;
    @Query
    @NameInMap(value="TranscodeOutput")
    private TranscodeOutput transcodeOutput;

    private UpdateLiveTranscodeJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.jobId = builder.jobId;
        this.name = builder.name;
        this.streamInput = builder.streamInput;
        this.timedConfig = builder.timedConfig;
        this.transcodeOutput = builder.transcodeOutput;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateLiveTranscodeJobRequest create() {
        return UpdateLiveTranscodeJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getName() {
        return this.name;
    }

    public StreamInput getStreamInput() {
        return this.streamInput;
    }

    public TimedConfig getTimedConfig() {
        return this.timedConfig;
    }

    public TranscodeOutput getTranscodeOutput() {
        return this.transcodeOutput;
    }

    public static class TranscodeOutput
    extends TeaModel {
        @NameInMap(value="DomainName")
        @Validation(required=true)
        private String domainName;
        @NameInMap(value="Type")
        @Validation(required=true)
        private String type;

        private TranscodeOutput(Builder builder) {
            this.domainName = builder.domainName;
            this.type = builder.type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TranscodeOutput create() {
            return TranscodeOutput.builder().build();
        }

        public String getDomainName() {
            return this.domainName;
        }

        public String getType() {
            return this.type;
        }

        public static final class Builder {
            private String domainName;
            private String type;

            private Builder() {
            }

            private Builder(TranscodeOutput model) {
                this.domainName = model.domainName;
                this.type = model.type;
            }

            public Builder domainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public TranscodeOutput build() {
                return new TranscodeOutput(this);
            }
        }
    }

    public static class TimedConfig
    extends TeaModel {
        @NameInMap(value="EndTime")
        private String endTime;
        @NameInMap(value="StartTime")
        private String startTime;

        private TimedConfig(Builder builder) {
            this.endTime = builder.endTime;
            this.startTime = builder.startTime;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TimedConfig create() {
            return TimedConfig.builder().build();
        }

        public String getEndTime() {
            return this.endTime;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public static final class Builder {
            private String endTime;
            private String startTime;

            private Builder() {
            }

            private Builder(TimedConfig model) {
                this.endTime = model.endTime;
                this.startTime = model.startTime;
            }

            public Builder endTime(String endTime) {
                this.endTime = endTime;
                return this;
            }

            public Builder startTime(String startTime) {
                this.startTime = startTime;
                return this;
            }

            public TimedConfig build() {
                return new TimedConfig(this);
            }
        }
    }

    public static class StreamInput
    extends TeaModel {
        @NameInMap(value="InputUrl")
        @Validation(required=true)
        private String inputUrl;
        @NameInMap(value="Type")
        @Validation(required=true)
        private String type;

        private StreamInput(Builder builder) {
            this.inputUrl = builder.inputUrl;
            this.type = builder.type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static StreamInput create() {
            return StreamInput.builder().build();
        }

        public String getInputUrl() {
            return this.inputUrl;
        }

        public String getType() {
            return this.type;
        }

        public static final class Builder {
            private String inputUrl;
            private String type;

            private Builder() {
            }

            private Builder(StreamInput model) {
                this.inputUrl = model.inputUrl;
                this.type = model.type;
            }

            public Builder inputUrl(String inputUrl) {
                this.inputUrl = inputUrl;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public StreamInput build() {
                return new StreamInput(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateLiveTranscodeJobRequest, Builder> {
        private String jobId;
        private String name;
        private StreamInput streamInput;
        private TimedConfig timedConfig;
        private TranscodeOutput transcodeOutput;

        private Builder() {
        }

        private Builder(UpdateLiveTranscodeJobRequest request) {
            super((Request)request);
            this.jobId = request.jobId;
            this.name = request.name;
            this.streamInput = request.streamInput;
            this.timedConfig = request.timedConfig;
            this.transcodeOutput = request.transcodeOutput;
        }

        public Builder jobId(String jobId) {
            this.putQueryParameter("JobId", jobId);
            this.jobId = jobId;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder streamInput(StreamInput streamInput) {
            String streamInputShrink = this.shrink((Object)streamInput, "StreamInput", "json");
            this.putQueryParameter("StreamInput", streamInputShrink);
            this.streamInput = streamInput;
            return this;
        }

        public Builder timedConfig(TimedConfig timedConfig) {
            String timedConfigShrink = this.shrink((Object)timedConfig, "TimedConfig", "json");
            this.putQueryParameter("TimedConfig", timedConfigShrink);
            this.timedConfig = timedConfig;
            return this;
        }

        public Builder transcodeOutput(TranscodeOutput transcodeOutput) {
            String transcodeOutputShrink = this.shrink((Object)transcodeOutput, "TranscodeOutput", "json");
            this.putQueryParameter("TranscodeOutput", transcodeOutputShrink);
            this.transcodeOutput = transcodeOutput;
            return this;
        }

        public UpdateLiveTranscodeJobRequest build() {
            return new UpdateLiveTranscodeJobRequest(this);
        }
    }
}

