/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ice20201109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdatePipelineRequest
extends Request {
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="PipelineId")
    @Validation(required=true)
    private String pipelineId;
    @Query
    @NameInMap(value="Priority")
    private Integer priority;
    @Query
    @NameInMap(value="Status")
    private String status;

    private UpdatePipelineRequest(Builder builder) {
        super((Request.Builder)builder);
        this.name = builder.name;
        this.pipelineId = builder.pipelineId;
        this.priority = builder.priority;
        this.status = builder.status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdatePipelineRequest create() {
        return UpdatePipelineRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getName() {
        return this.name;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getStatus() {
        return this.status;
    }

    public static final class Builder
    extends Request.Builder<UpdatePipelineRequest, Builder> {
        private String name;
        private String pipelineId;
        private Integer priority;
        private String status;

        private Builder() {
        }

        private Builder(UpdatePipelineRequest request) {
            super((Request)request);
            this.name = request.name;
            this.pipelineId = request.pipelineId;
            this.priority = request.priority;
            this.status = request.status;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder pipelineId(String pipelineId) {
            this.putQueryParameter("PipelineId", pipelineId);
            this.pipelineId = pipelineId;
            return this;
        }

        public Builder priority(Integer priority) {
            this.putQueryParameter("Priority", priority);
            this.priority = priority;
            return this;
        }

        public Builder status(String status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }
    }
}

