/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AddDataForApiSourceRequest
extends Request {
    @Query
    @NameInMap(value="ApiId")
    @Validation(required=true)
    private String apiId;
    @Query
    @NameInMap(value="Content")
    @Validation(required=true)
    private String content;
    @Query
    @NameInMap(value="IotInstanceId")
    @Validation(required=true)
    private String iotInstanceId;

    private AddDataForApiSourceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.apiId = builder.apiId;
        this.content = builder.content;
        this.iotInstanceId = builder.iotInstanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddDataForApiSourceRequest create() {
        return AddDataForApiSourceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getApiId() {
        return this.apiId;
    }

    public String getContent() {
        return this.content;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public static final class Builder
    extends Request.Builder<AddDataForApiSourceRequest, Builder> {
        private String apiId;
        private String content;
        private String iotInstanceId;

        private Builder() {
        }

        private Builder(AddDataForApiSourceRequest request) {
            super((Request)request);
            this.apiId = request.apiId;
            this.content = request.content;
            this.iotInstanceId = request.iotInstanceId;
        }

        public Builder apiId(String apiId) {
            this.putQueryParameter("ApiId", apiId);
            this.apiId = apiId;
            return this;
        }

        public Builder content(String content) {
            this.putQueryParameter("Content", content);
            this.content = content;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public AddDataForApiSourceRequest build() {
            return new AddDataForApiSourceRequest(this);
        }
    }
}

