/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class BatchCheckDeviceNamesRequest
extends Request {
    @Query
    @NameInMap(value="DeviceName")
    private List<String> deviceName;
    @Query
    @NameInMap(value="DeviceNameList")
    private List<DeviceNameList> deviceNameList;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;

    private BatchCheckDeviceNamesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.deviceNameList = builder.deviceNameList;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchCheckDeviceNamesRequest create() {
        return BatchCheckDeviceNamesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getDeviceName() {
        return this.deviceName;
    }

    public List<DeviceNameList> getDeviceNameList() {
        return this.deviceNameList;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static class DeviceNameList
    extends TeaModel {
        @NameInMap(value="DeviceName")
        private String deviceName;
        @NameInMap(value="DeviceNickname")
        private String deviceNickname;

        private DeviceNameList(Builder builder) {
            this.deviceName = builder.deviceName;
            this.deviceNickname = builder.deviceNickname;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DeviceNameList create() {
            return DeviceNameList.builder().build();
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public String getDeviceNickname() {
            return this.deviceNickname;
        }

        public static final class Builder {
            private String deviceName;
            private String deviceNickname;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder deviceNickname(String deviceNickname) {
                this.deviceNickname = deviceNickname;
                return this;
            }

            public DeviceNameList build() {
                return new DeviceNameList(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<BatchCheckDeviceNamesRequest, Builder> {
        private List<String> deviceName;
        private List<DeviceNameList> deviceNameList;
        private String iotInstanceId;
        private String productKey;

        private Builder() {
        }

        private Builder(BatchCheckDeviceNamesRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.deviceNameList = request.deviceNameList;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
        }

        public Builder deviceName(List<String> deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder deviceNameList(List<DeviceNameList> deviceNameList) {
            this.putQueryParameter("DeviceNameList", deviceNameList);
            this.deviceNameList = deviceNameList;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public BatchCheckDeviceNamesRequest build() {
            return new BatchCheckDeviceNamesRequest(this);
        }
    }
}

