/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class BatchDeleteDeviceGroupRelationsRequest
extends Request {
    @Query
    @NameInMap(value="Device")
    private List<Device> device;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;

    private BatchDeleteDeviceGroupRelationsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.device = builder.device;
        this.groupId = builder.groupId;
        this.iotInstanceId = builder.iotInstanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchDeleteDeviceGroupRelationsRequest create() {
        return BatchDeleteDeviceGroupRelationsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Device> getDevice() {
        return this.device;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public static class Device
    extends TeaModel {
        @NameInMap(value="DeviceName")
        @Validation(required=true)
        private String deviceName;
        @NameInMap(value="ProductKey")
        @Validation(required=true)
        private String productKey;

        private Device(Builder builder) {
            this.deviceName = builder.deviceName;
            this.productKey = builder.productKey;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Device create() {
            return Device.builder().build();
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public String getProductKey() {
            return this.productKey;
        }

        public static final class Builder {
            private String deviceName;
            private String productKey;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder productKey(String productKey) {
                this.productKey = productKey;
                return this;
            }

            public Device build() {
                return new Device(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<BatchDeleteDeviceGroupRelationsRequest, Builder> {
        private List<Device> device;
        private String groupId;
        private String iotInstanceId;

        private Builder() {
        }

        private Builder(BatchDeleteDeviceGroupRelationsRequest request) {
            super((Request)request);
            this.device = request.device;
            this.groupId = request.groupId;
            this.iotInstanceId = request.iotInstanceId;
        }

        public Builder device(List<Device> device) {
            this.putQueryParameter("Device", device);
            this.device = device;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public BatchDeleteDeviceGroupRelationsRequest build() {
            return new BatchDeleteDeviceGroupRelationsRequest(this);
        }
    }
}

