/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class BatchImportDeviceRequest
extends Request {
    @Query
    @NameInMap(value="DeviceList")
    @Validation(required=true)
    private List<DeviceList> deviceList;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;

    private BatchImportDeviceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceList = builder.deviceList;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchImportDeviceRequest create() {
        return BatchImportDeviceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<DeviceList> getDeviceList() {
        return this.deviceList;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static class DeviceList
    extends TeaModel {
        @NameInMap(value="DeviceName")
        @Validation(required=true)
        private String deviceName;
        @NameInMap(value="DeviceSecret")
        @Validation(required=true)
        private String deviceSecret;
        @NameInMap(value="Sn")
        private String sn;

        private DeviceList(Builder builder) {
            this.deviceName = builder.deviceName;
            this.deviceSecret = builder.deviceSecret;
            this.sn = builder.sn;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DeviceList create() {
            return DeviceList.builder().build();
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public String getDeviceSecret() {
            return this.deviceSecret;
        }

        public String getSn() {
            return this.sn;
        }

        public static final class Builder {
            private String deviceName;
            private String deviceSecret;
            private String sn;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder deviceSecret(String deviceSecret) {
                this.deviceSecret = deviceSecret;
                return this;
            }

            public Builder sn(String sn) {
                this.sn = sn;
                return this;
            }

            public DeviceList build() {
                return new DeviceList(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<BatchImportDeviceRequest, Builder> {
        private List<DeviceList> deviceList;
        private String iotInstanceId;
        private String productKey;

        private Builder() {
        }

        private Builder(BatchImportDeviceRequest request) {
            super((Request)request);
            this.deviceList = request.deviceList;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
        }

        public Builder deviceList(List<DeviceList> deviceList) {
            this.putQueryParameter("DeviceList", deviceList);
            this.deviceList = deviceList;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public BatchImportDeviceRequest build() {
            return new BatchImportDeviceRequest(this);
        }
    }
}

