/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class BatchPubRequest
extends Request {
    @Query
    @NameInMap(value="DeviceName")
    @Validation(required=true)
    private List<String> deviceName;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="MessageContent")
    @Validation(required=true)
    private String messageContent;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="Qos")
    private Integer qos;
    @Query
    @NameInMap(value="TopicShortName")
    @Validation(required=true)
    private String topicShortName;

    private BatchPubRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.iotInstanceId = builder.iotInstanceId;
        this.messageContent = builder.messageContent;
        this.productKey = builder.productKey;
        this.qos = builder.qos;
        this.topicShortName = builder.topicShortName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchPubRequest create() {
        return BatchPubRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getDeviceName() {
        return this.deviceName;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public Integer getQos() {
        return this.qos;
    }

    public String getTopicShortName() {
        return this.topicShortName;
    }

    public static final class Builder
    extends Request.Builder<BatchPubRequest, Builder> {
        private List<String> deviceName;
        private String iotInstanceId;
        private String messageContent;
        private String productKey;
        private Integer qos;
        private String topicShortName;

        private Builder() {
        }

        private Builder(BatchPubRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.iotInstanceId = request.iotInstanceId;
            this.messageContent = request.messageContent;
            this.productKey = request.productKey;
            this.qos = request.qos;
            this.topicShortName = request.topicShortName;
        }

        public Builder deviceName(List<String> deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder messageContent(String messageContent) {
            this.putQueryParameter("MessageContent", messageContent);
            this.messageContent = messageContent;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder qos(Integer qos) {
            this.putQueryParameter("Qos", qos);
            this.qos = qos;
            return this;
        }

        public Builder topicShortName(String topicShortName) {
            this.putQueryParameter("TopicShortName", topicShortName);
            this.topicShortName = topicShortName;
            return this;
        }

        public BatchPubRequest build() {
            return new BatchPubRequest(this);
        }
    }
}

