/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class BatchUpdateDeviceNicknameRequest
extends Request {
    @Query
    @NameInMap(value="DeviceNicknameInfo")
    @Validation(required=true)
    private List<DeviceNicknameInfo> deviceNicknameInfo;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;

    private BatchUpdateDeviceNicknameRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceNicknameInfo = builder.deviceNicknameInfo;
        this.iotInstanceId = builder.iotInstanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchUpdateDeviceNicknameRequest create() {
        return BatchUpdateDeviceNicknameRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<DeviceNicknameInfo> getDeviceNicknameInfo() {
        return this.deviceNicknameInfo;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public static class DeviceNicknameInfo
    extends TeaModel {
        @NameInMap(value="DeviceName")
        private String deviceName;
        @NameInMap(value="IotId")
        private String iotId;
        @NameInMap(value="Nickname")
        private String nickname;
        @NameInMap(value="ProductKey")
        private String productKey;

        private DeviceNicknameInfo(Builder builder) {
            this.deviceName = builder.deviceName;
            this.iotId = builder.iotId;
            this.nickname = builder.nickname;
            this.productKey = builder.productKey;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DeviceNicknameInfo create() {
            return DeviceNicknameInfo.builder().build();
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public String getIotId() {
            return this.iotId;
        }

        public String getNickname() {
            return this.nickname;
        }

        public String getProductKey() {
            return this.productKey;
        }

        public static final class Builder {
            private String deviceName;
            private String iotId;
            private String nickname;
            private String productKey;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder iotId(String iotId) {
                this.iotId = iotId;
                return this;
            }

            public Builder nickname(String nickname) {
                this.nickname = nickname;
                return this;
            }

            public Builder productKey(String productKey) {
                this.productKey = productKey;
                return this;
            }

            public DeviceNicknameInfo build() {
                return new DeviceNicknameInfo(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<BatchUpdateDeviceNicknameRequest, Builder> {
        private List<DeviceNicknameInfo> deviceNicknameInfo;
        private String iotInstanceId;

        private Builder() {
        }

        private Builder(BatchUpdateDeviceNicknameRequest request) {
            super((Request)request);
            this.deviceNicknameInfo = request.deviceNicknameInfo;
            this.iotInstanceId = request.iotInstanceId;
        }

        public Builder deviceNicknameInfo(List<DeviceNicknameInfo> deviceNicknameInfo) {
            this.putQueryParameter("DeviceNicknameInfo", deviceNicknameInfo);
            this.deviceNicknameInfo = deviceNicknameInfo;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public BatchUpdateDeviceNicknameRequest build() {
            return new BatchUpdateDeviceNicknameRequest(this);
        }
    }
}

