/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class BindApplicationToEdgeInstanceRequest
extends Request {
    @Query
    @NameInMap(value="ApplicationId")
    @Validation(required=true)
    private String applicationId;
    @Query
    @NameInMap(value="ApplicationVersion")
    @Validation(required=true)
    private String applicationVersion;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;

    private BindApplicationToEdgeInstanceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.applicationId = builder.applicationId;
        this.applicationVersion = builder.applicationVersion;
        this.instanceId = builder.instanceId;
        this.iotInstanceId = builder.iotInstanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BindApplicationToEdgeInstanceRequest create() {
        return BindApplicationToEdgeInstanceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public static final class Builder
    extends Request.Builder<BindApplicationToEdgeInstanceRequest, Builder> {
        private String applicationId;
        private String applicationVersion;
        private String instanceId;
        private String iotInstanceId;

        private Builder() {
        }

        private Builder(BindApplicationToEdgeInstanceRequest request) {
            super((Request)request);
            this.applicationId = request.applicationId;
            this.applicationVersion = request.applicationVersion;
            this.instanceId = request.instanceId;
            this.iotInstanceId = request.iotInstanceId;
        }

        public Builder applicationId(String applicationId) {
            this.putQueryParameter("ApplicationId", applicationId);
            this.applicationId = applicationId;
            return this;
        }

        public Builder applicationVersion(String applicationVersion) {
            this.putQueryParameter("ApplicationVersion", applicationVersion);
            this.applicationVersion = applicationVersion;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public BindApplicationToEdgeInstanceRequest build() {
            return new BindApplicationToEdgeInstanceRequest(this);
        }
    }
}

