/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class CancelOTATaskByDeviceRequest
extends Request {
    @Query
    @NameInMap(value="DeviceName")
    @Validation(required=true)
    private List<String> deviceName;
    @Query
    @NameInMap(value="FirmwareId")
    @Validation(required=true)
    private String firmwareId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="JobId")
    private String jobId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;

    private CancelOTATaskByDeviceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.firmwareId = builder.firmwareId;
        this.iotInstanceId = builder.iotInstanceId;
        this.jobId = builder.jobId;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CancelOTATaskByDeviceRequest create() {
        return CancelOTATaskByDeviceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getDeviceName() {
        return this.deviceName;
    }

    public String getFirmwareId() {
        return this.firmwareId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static final class Builder
    extends Request.Builder<CancelOTATaskByDeviceRequest, Builder> {
        private List<String> deviceName;
        private String firmwareId;
        private String iotInstanceId;
        private String jobId;
        private String productKey;

        private Builder() {
        }

        private Builder(CancelOTATaskByDeviceRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.firmwareId = request.firmwareId;
            this.iotInstanceId = request.iotInstanceId;
            this.jobId = request.jobId;
            this.productKey = request.productKey;
        }

        public Builder deviceName(List<String> deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder firmwareId(String firmwareId) {
            this.putQueryParameter("FirmwareId", firmwareId);
            this.firmwareId = firmwareId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder jobId(String jobId) {
            this.putQueryParameter("JobId", jobId);
            this.jobId = jobId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public CancelOTATaskByDeviceRequest build() {
            return new CancelOTATaskByDeviceRequest(this);
        }
    }
}

