/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateDeviceDistributeJobRequest
extends Request {
    @Body
    @NameInMap(value="DeviceName")
    @Validation(required=true)
    private List<String> deviceName;
    @Body
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Body
    @NameInMap(value="SourceInstanceId")
    @Validation(required=true)
    private String sourceInstanceId;
    @Body
    @NameInMap(value="Strategy")
    @Validation(required=true)
    private Integer strategy;
    @Body
    @NameInMap(value="TargetAliyunId")
    private String targetAliyunId;
    @Body
    @NameInMap(value="TargetInstanceConfig")
    @Validation(required=true)
    private List<TargetInstanceConfig> targetInstanceConfig;
    @Body
    @NameInMap(value="TargetUid")
    private String targetUid;

    private CreateDeviceDistributeJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.productKey = builder.productKey;
        this.sourceInstanceId = builder.sourceInstanceId;
        this.strategy = builder.strategy;
        this.targetAliyunId = builder.targetAliyunId;
        this.targetInstanceConfig = builder.targetInstanceConfig;
        this.targetUid = builder.targetUid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateDeviceDistributeJobRequest create() {
        return CreateDeviceDistributeJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getDeviceName() {
        return this.deviceName;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getSourceInstanceId() {
        return this.sourceInstanceId;
    }

    public Integer getStrategy() {
        return this.strategy;
    }

    public String getTargetAliyunId() {
        return this.targetAliyunId;
    }

    public List<TargetInstanceConfig> getTargetInstanceConfig() {
        return this.targetInstanceConfig;
    }

    public String getTargetUid() {
        return this.targetUid;
    }

    public static class TargetInstanceConfig
    extends TeaModel {
        @NameInMap(value="TargetInstanceId")
        @Validation(required=true)
        private String targetInstanceId;

        private TargetInstanceConfig(Builder builder) {
            this.targetInstanceId = builder.targetInstanceId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TargetInstanceConfig create() {
            return TargetInstanceConfig.builder().build();
        }

        public String getTargetInstanceId() {
            return this.targetInstanceId;
        }

        public static final class Builder {
            private String targetInstanceId;

            public Builder targetInstanceId(String targetInstanceId) {
                this.targetInstanceId = targetInstanceId;
                return this;
            }

            public TargetInstanceConfig build() {
                return new TargetInstanceConfig(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateDeviceDistributeJobRequest, Builder> {
        private List<String> deviceName;
        private String productKey;
        private String sourceInstanceId;
        private Integer strategy;
        private String targetAliyunId;
        private List<TargetInstanceConfig> targetInstanceConfig;
        private String targetUid;

        private Builder() {
        }

        private Builder(CreateDeviceDistributeJobRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.productKey = request.productKey;
            this.sourceInstanceId = request.sourceInstanceId;
            this.strategy = request.strategy;
            this.targetAliyunId = request.targetAliyunId;
            this.targetInstanceConfig = request.targetInstanceConfig;
            this.targetUid = request.targetUid;
        }

        public Builder deviceName(List<String> deviceName) {
            this.putBodyParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putBodyParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder sourceInstanceId(String sourceInstanceId) {
            this.putBodyParameter("SourceInstanceId", sourceInstanceId);
            this.sourceInstanceId = sourceInstanceId;
            return this;
        }

        public Builder strategy(Integer strategy) {
            this.putBodyParameter("Strategy", strategy);
            this.strategy = strategy;
            return this;
        }

        public Builder targetAliyunId(String targetAliyunId) {
            this.putBodyParameter("TargetAliyunId", targetAliyunId);
            this.targetAliyunId = targetAliyunId;
            return this;
        }

        public Builder targetInstanceConfig(List<TargetInstanceConfig> targetInstanceConfig) {
            this.putBodyParameter("TargetInstanceConfig", targetInstanceConfig);
            this.targetInstanceConfig = targetInstanceConfig;
            return this;
        }

        public Builder targetUid(String targetUid) {
            this.putBodyParameter("TargetUid", targetUid);
            this.targetUid = targetUid;
            return this;
        }

        public CreateDeviceDistributeJobRequest build() {
            return new CreateDeviceDistributeJobRequest(this);
        }
    }
}

