/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateEdgeInstanceMessageRoutingRequest
extends Request {
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="SourceData")
    private String sourceData;
    @Query
    @NameInMap(value="SourceType")
    @Validation(required=true)
    private String sourceType;
    @Query
    @NameInMap(value="TargetData")
    private String targetData;
    @Query
    @NameInMap(value="TargetIotHubQos")
    private Integer targetIotHubQos;
    @Query
    @NameInMap(value="TargetType")
    @Validation(required=true)
    private String targetType;
    @Query
    @NameInMap(value="TopicFilter")
    private String topicFilter;

    private CreateEdgeInstanceMessageRoutingRequest(Builder builder) {
        super((Request.Builder)builder);
        this.instanceId = builder.instanceId;
        this.iotInstanceId = builder.iotInstanceId;
        this.name = builder.name;
        this.sourceData = builder.sourceData;
        this.sourceType = builder.sourceType;
        this.targetData = builder.targetData;
        this.targetIotHubQos = builder.targetIotHubQos;
        this.targetType = builder.targetType;
        this.topicFilter = builder.topicFilter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateEdgeInstanceMessageRoutingRequest create() {
        return CreateEdgeInstanceMessageRoutingRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceData() {
        return this.sourceData;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getTargetData() {
        return this.targetData;
    }

    public Integer getTargetIotHubQos() {
        return this.targetIotHubQos;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getTopicFilter() {
        return this.topicFilter;
    }

    public static final class Builder
    extends Request.Builder<CreateEdgeInstanceMessageRoutingRequest, Builder> {
        private String instanceId;
        private String iotInstanceId;
        private String name;
        private String sourceData;
        private String sourceType;
        private String targetData;
        private Integer targetIotHubQos;
        private String targetType;
        private String topicFilter;

        private Builder() {
        }

        private Builder(CreateEdgeInstanceMessageRoutingRequest request) {
            super((Request)request);
            this.instanceId = request.instanceId;
            this.iotInstanceId = request.iotInstanceId;
            this.name = request.name;
            this.sourceData = request.sourceData;
            this.sourceType = request.sourceType;
            this.targetData = request.targetData;
            this.targetIotHubQos = request.targetIotHubQos;
            this.targetType = request.targetType;
            this.topicFilter = request.topicFilter;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder sourceData(String sourceData) {
            this.putQueryParameter("SourceData", sourceData);
            this.sourceData = sourceData;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.putQueryParameter("SourceType", sourceType);
            this.sourceType = sourceType;
            return this;
        }

        public Builder targetData(String targetData) {
            this.putQueryParameter("TargetData", targetData);
            this.targetData = targetData;
            return this;
        }

        public Builder targetIotHubQos(Integer targetIotHubQos) {
            this.putQueryParameter("TargetIotHubQos", targetIotHubQos);
            this.targetIotHubQos = targetIotHubQos;
            return this;
        }

        public Builder targetType(String targetType) {
            this.putQueryParameter("TargetType", targetType);
            this.targetType = targetType;
            return this;
        }

        public Builder topicFilter(String topicFilter) {
            this.putQueryParameter("TopicFilter", topicFilter);
            this.topicFilter = topicFilter;
            return this;
        }

        public CreateEdgeInstanceMessageRoutingRequest build() {
            return new CreateEdgeInstanceMessageRoutingRequest(this);
        }
    }
}

