/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateProductRequest
extends Request {
    @Query
    @NameInMap(value="AliyunCommodityCode")
    private String aliyunCommodityCode;
    @Query
    @NameInMap(value="AuthType")
    private String authType;
    @Query
    @NameInMap(value="CategoryKey")
    private String categoryKey;
    @Query
    @NameInMap(value="DataFormat")
    private Integer dataFormat;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="Id2")
    private Boolean id2;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="JoinPermissionId")
    private String joinPermissionId;
    @Query
    @NameInMap(value="NetType")
    private String netType;
    @Query
    @NameInMap(value="NodeType")
    @Validation(required=true)
    private Integer nodeType;
    @Query
    @NameInMap(value="ProductName")
    @Validation(required=true)
    private String productName;
    @Query
    @NameInMap(value="ProtocolType")
    private String protocolType;
    @Query
    @NameInMap(value="PublishAuto")
    private Boolean publishAuto;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;
    @Query
    @NameInMap(value="ValidateType")
    private Integer validateType;

    private CreateProductRequest(Builder builder) {
        super((Request.Builder)builder);
        this.aliyunCommodityCode = builder.aliyunCommodityCode;
        this.authType = builder.authType;
        this.categoryKey = builder.categoryKey;
        this.dataFormat = builder.dataFormat;
        this.description = builder.description;
        this.id2 = builder.id2;
        this.iotInstanceId = builder.iotInstanceId;
        this.joinPermissionId = builder.joinPermissionId;
        this.netType = builder.netType;
        this.nodeType = builder.nodeType;
        this.productName = builder.productName;
        this.protocolType = builder.protocolType;
        this.publishAuto = builder.publishAuto;
        this.resourceGroupId = builder.resourceGroupId;
        this.validateType = builder.validateType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateProductRequest create() {
        return CreateProductRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAliyunCommodityCode() {
        return this.aliyunCommodityCode;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCategoryKey() {
        return this.categoryKey;
    }

    public Integer getDataFormat() {
        return this.dataFormat;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getId2() {
        return this.id2;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getJoinPermissionId() {
        return this.joinPermissionId;
    }

    public String getNetType() {
        return this.netType;
    }

    public Integer getNodeType() {
        return this.nodeType;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public Boolean getPublishAuto() {
        return this.publishAuto;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public Integer getValidateType() {
        return this.validateType;
    }

    public static final class Builder
    extends Request.Builder<CreateProductRequest, Builder> {
        private String aliyunCommodityCode;
        private String authType;
        private String categoryKey;
        private Integer dataFormat;
        private String description;
        private Boolean id2;
        private String iotInstanceId;
        private String joinPermissionId;
        private String netType;
        private Integer nodeType;
        private String productName;
        private String protocolType;
        private Boolean publishAuto;
        private String resourceGroupId;
        private Integer validateType;

        private Builder() {
        }

        private Builder(CreateProductRequest request) {
            super((Request)request);
            this.aliyunCommodityCode = request.aliyunCommodityCode;
            this.authType = request.authType;
            this.categoryKey = request.categoryKey;
            this.dataFormat = request.dataFormat;
            this.description = request.description;
            this.id2 = request.id2;
            this.iotInstanceId = request.iotInstanceId;
            this.joinPermissionId = request.joinPermissionId;
            this.netType = request.netType;
            this.nodeType = request.nodeType;
            this.productName = request.productName;
            this.protocolType = request.protocolType;
            this.publishAuto = request.publishAuto;
            this.resourceGroupId = request.resourceGroupId;
            this.validateType = request.validateType;
        }

        public Builder aliyunCommodityCode(String aliyunCommodityCode) {
            this.putQueryParameter("AliyunCommodityCode", aliyunCommodityCode);
            this.aliyunCommodityCode = aliyunCommodityCode;
            return this;
        }

        public Builder authType(String authType) {
            this.putQueryParameter("AuthType", authType);
            this.authType = authType;
            return this;
        }

        public Builder categoryKey(String categoryKey) {
            this.putQueryParameter("CategoryKey", categoryKey);
            this.categoryKey = categoryKey;
            return this;
        }

        public Builder dataFormat(Integer dataFormat) {
            this.putQueryParameter("DataFormat", dataFormat);
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder id2(Boolean id2) {
            this.putQueryParameter("Id2", id2);
            this.id2 = id2;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder joinPermissionId(String joinPermissionId) {
            this.putQueryParameter("JoinPermissionId", joinPermissionId);
            this.joinPermissionId = joinPermissionId;
            return this;
        }

        public Builder netType(String netType) {
            this.putQueryParameter("NetType", netType);
            this.netType = netType;
            return this;
        }

        public Builder nodeType(Integer nodeType) {
            this.putQueryParameter("NodeType", nodeType);
            this.nodeType = nodeType;
            return this;
        }

        public Builder productName(String productName) {
            this.putQueryParameter("ProductName", productName);
            this.productName = productName;
            return this;
        }

        public Builder protocolType(String protocolType) {
            this.putQueryParameter("ProtocolType", protocolType);
            this.protocolType = protocolType;
            return this;
        }

        public Builder publishAuto(Boolean publishAuto) {
            this.putQueryParameter("PublishAuto", publishAuto);
            this.publishAuto = publishAuto;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder validateType(Integer validateType) {
            this.putQueryParameter("ValidateType", validateType);
            this.validateType = validateType;
            return this;
        }

        public CreateProductRequest build() {
            return new CreateProductRequest(this);
        }
    }
}

