/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateSceneRuleRequest
extends Request {
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="RuleContent")
    private String ruleContent;
    @Query
    @NameInMap(value="RuleDescription")
    private String ruleDescription;
    @Query
    @NameInMap(value="RuleName")
    @Validation(required=true)
    private String ruleName;

    private CreateSceneRuleRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.ruleContent = builder.ruleContent;
        this.ruleDescription = builder.ruleDescription;
        this.ruleName = builder.ruleName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateSceneRuleRequest create() {
        return CreateSceneRuleRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getRuleContent() {
        return this.ruleContent;
    }

    public String getRuleDescription() {
        return this.ruleDescription;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public static final class Builder
    extends Request.Builder<CreateSceneRuleRequest, Builder> {
        private String iotInstanceId;
        private String ruleContent;
        private String ruleDescription;
        private String ruleName;

        private Builder() {
        }

        private Builder(CreateSceneRuleRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.ruleContent = request.ruleContent;
            this.ruleDescription = request.ruleDescription;
            this.ruleName = request.ruleName;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder ruleContent(String ruleContent) {
            this.putQueryParameter("RuleContent", ruleContent);
            this.ruleContent = ruleContent;
            return this;
        }

        public Builder ruleDescription(String ruleDescription) {
            this.putQueryParameter("RuleDescription", ruleDescription);
            this.ruleDescription = ruleDescription;
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.putQueryParameter("RuleName", ruleName);
            this.ruleName = ruleName;
            return this;
        }

        public CreateSceneRuleRequest build() {
            return new CreateSceneRuleRequest(this);
        }
    }
}

