/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class CreateSpeechRequest
extends Request {
    @Body
    @NameInMap(value="AudioFormat")
    private String audioFormat;
    @Body
    @NameInMap(value="BizCode")
    private String bizCode;
    @Body
    @NameInMap(value="EnableSoundCode")
    private Boolean enableSoundCode;
    @Body
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Body
    @NameInMap(value="ProjectCode")
    @Validation(required=true)
    private String projectCode;
    @Body
    @NameInMap(value="SoundCodeConfig")
    private Map<String, ?> soundCodeConfig;
    @Body
    @NameInMap(value="SpeechRate")
    @Validation(maximum=500.0)
    private Integer speechRate;
    @Body
    @NameInMap(value="SpeechType")
    private String speechType;
    @Body
    @NameInMap(value="Text")
    private String text;
    @Body
    @NameInMap(value="Voice")
    @Validation(required=true)
    private String voice;
    @Body
    @NameInMap(value="Volume")
    @Validation(maximum=100.0)
    private Integer volume;

    private CreateSpeechRequest(Builder builder) {
        super((Request.Builder)builder);
        this.audioFormat = builder.audioFormat;
        this.bizCode = builder.bizCode;
        this.enableSoundCode = builder.enableSoundCode;
        this.iotInstanceId = builder.iotInstanceId;
        this.projectCode = builder.projectCode;
        this.soundCodeConfig = builder.soundCodeConfig;
        this.speechRate = builder.speechRate;
        this.speechType = builder.speechType;
        this.text = builder.text;
        this.voice = builder.voice;
        this.volume = builder.volume;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateSpeechRequest create() {
        return CreateSpeechRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAudioFormat() {
        return this.audioFormat;
    }

    public String getBizCode() {
        return this.bizCode;
    }

    public Boolean getEnableSoundCode() {
        return this.enableSoundCode;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public Map<String, ?> getSoundCodeConfig() {
        return this.soundCodeConfig;
    }

    public Integer getSpeechRate() {
        return this.speechRate;
    }

    public String getSpeechType() {
        return this.speechType;
    }

    public String getText() {
        return this.text;
    }

    public String getVoice() {
        return this.voice;
    }

    public Integer getVolume() {
        return this.volume;
    }

    public static final class Builder
    extends Request.Builder<CreateSpeechRequest, Builder> {
        private String audioFormat;
        private String bizCode;
        private Boolean enableSoundCode;
        private String iotInstanceId;
        private String projectCode;
        private Map<String, ?> soundCodeConfig;
        private Integer speechRate;
        private String speechType;
        private String text;
        private String voice;
        private Integer volume;

        private Builder() {
        }

        private Builder(CreateSpeechRequest request) {
            super((Request)request);
            this.audioFormat = request.audioFormat;
            this.bizCode = request.bizCode;
            this.enableSoundCode = request.enableSoundCode;
            this.iotInstanceId = request.iotInstanceId;
            this.projectCode = request.projectCode;
            this.soundCodeConfig = request.soundCodeConfig;
            this.speechRate = request.speechRate;
            this.speechType = request.speechType;
            this.text = request.text;
            this.voice = request.voice;
            this.volume = request.volume;
        }

        public Builder audioFormat(String audioFormat) {
            this.putBodyParameter("AudioFormat", audioFormat);
            this.audioFormat = audioFormat;
            return this;
        }

        public Builder bizCode(String bizCode) {
            this.putBodyParameter("BizCode", bizCode);
            this.bizCode = bizCode;
            return this;
        }

        public Builder enableSoundCode(Boolean enableSoundCode) {
            this.putBodyParameter("EnableSoundCode", enableSoundCode);
            this.enableSoundCode = enableSoundCode;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putBodyParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder projectCode(String projectCode) {
            this.putBodyParameter("ProjectCode", projectCode);
            this.projectCode = projectCode;
            return this;
        }

        public Builder soundCodeConfig(Map<String, ?> soundCodeConfig) {
            String soundCodeConfigShrink = this.shrink(soundCodeConfig, "SoundCodeConfig", "json");
            this.putBodyParameter("SoundCodeConfig", soundCodeConfigShrink);
            this.soundCodeConfig = soundCodeConfig;
            return this;
        }

        public Builder speechRate(Integer speechRate) {
            this.putBodyParameter("SpeechRate", speechRate);
            this.speechRate = speechRate;
            return this;
        }

        public Builder speechType(String speechType) {
            this.putBodyParameter("SpeechType", speechType);
            this.speechType = speechType;
            return this;
        }

        public Builder text(String text) {
            this.putBodyParameter("Text", text);
            this.text = text;
            return this;
        }

        public Builder voice(String voice) {
            this.putBodyParameter("Voice", voice);
            this.voice = voice;
            return this;
        }

        public Builder volume(Integer volume) {
            this.putBodyParameter("Volume", volume);
            this.volume = volume;
            return this;
        }

        public CreateSpeechRequest build() {
            return new CreateSpeechRequest(this);
        }
    }
}

