/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DeleteDestinationRequest
extends Request {
    @Query
    @NameInMap(value="DestinationId")
    @Validation(required=true, maximum=9999999.0)
    private Long destinationId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;

    private DeleteDestinationRequest(Builder builder) {
        super((Request.Builder)builder);
        this.destinationId = builder.destinationId;
        this.iotInstanceId = builder.iotInstanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DeleteDestinationRequest create() {
        return DeleteDestinationRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getDestinationId() {
        return this.destinationId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public static final class Builder
    extends Request.Builder<DeleteDestinationRequest, Builder> {
        private Long destinationId;
        private String iotInstanceId;

        private Builder() {
        }

        private Builder(DeleteDestinationRequest request) {
            super((Request)request);
            this.destinationId = request.destinationId;
            this.iotInstanceId = request.iotInstanceId;
        }

        public Builder destinationId(Long destinationId) {
            this.putQueryParameter("DestinationId", destinationId);
            this.destinationId = destinationId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public DeleteDestinationRequest build() {
            return new DeleteDestinationRequest(this);
        }
    }
}

