/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DeleteDevicePropRequest
extends Request {
    @Query
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="IotId")
    private String iotId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;
    @Query
    @NameInMap(value="PropKey")
    @Validation(required=true)
    private String propKey;

    private DeleteDevicePropRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.iotId = builder.iotId;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
        this.propKey = builder.propKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DeleteDevicePropRequest create() {
        return DeleteDevicePropRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIotId() {
        return this.iotId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getPropKey() {
        return this.propKey;
    }

    public static final class Builder
    extends Request.Builder<DeleteDevicePropRequest, Builder> {
        private String deviceName;
        private String iotId;
        private String iotInstanceId;
        private String productKey;
        private String propKey;

        private Builder() {
        }

        private Builder(DeleteDevicePropRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.iotId = request.iotId;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
            this.propKey = request.propKey;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotId(String iotId) {
            this.putQueryParameter("IotId", iotId);
            this.iotId = iotId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder propKey(String propKey) {
            this.putQueryParameter("PropKey", propKey);
            this.propKey = propKey;
            return this;
        }

        public DeleteDevicePropRequest build() {
            return new DeleteDevicePropRequest(this);
        }
    }
}

