/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DetachParserDataSourceRequest
extends Request {
    @Query
    @NameInMap(value="DataSourceId")
    @Validation(required=true, maximum=9.9999999E7)
    private Long dataSourceId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ParserId")
    @Validation(required=true, maximum=9.99999999999E11, minimum=1.0)
    private Long parserId;

    private DetachParserDataSourceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.dataSourceId = builder.dataSourceId;
        this.iotInstanceId = builder.iotInstanceId;
        this.parserId = builder.parserId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DetachParserDataSourceRequest create() {
        return DetachParserDataSourceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getDataSourceId() {
        return this.dataSourceId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Long getParserId() {
        return this.parserId;
    }

    public static final class Builder
    extends Request.Builder<DetachParserDataSourceRequest, Builder> {
        private Long dataSourceId;
        private String iotInstanceId;
        private Long parserId;

        private Builder() {
        }

        private Builder(DetachParserDataSourceRequest request) {
            super((Request)request);
            this.dataSourceId = request.dataSourceId;
            this.iotInstanceId = request.iotInstanceId;
            this.parserId = request.parserId;
        }

        public Builder dataSourceId(Long dataSourceId) {
            this.putQueryParameter("DataSourceId", dataSourceId);
            this.dataSourceId = dataSourceId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder parserId(Long parserId) {
            this.putQueryParameter("ParserId", parserId);
            this.parserId = parserId;
            return this;
        }

        public DetachParserDataSourceRequest build() {
            return new DetachParserDataSourceRequest(this);
        }
    }
}

