/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class GetThingTopoRequest
extends Request {
    @Query
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="IotId")
    private String iotId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="PageNo")
    @Validation(required=true)
    private Integer pageNo;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true)
    private Integer pageSize;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;

    private GetThingTopoRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.iotId = builder.iotId;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetThingTopoRequest create() {
        return GetThingTopoRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIotId() {
        return this.iotId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static final class Builder
    extends Request.Builder<GetThingTopoRequest, Builder> {
        private String deviceName;
        private String iotId;
        private String iotInstanceId;
        private Integer pageNo;
        private Integer pageSize;
        private String productKey;

        private Builder() {
        }

        private Builder(GetThingTopoRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.iotId = request.iotId;
            this.iotInstanceId = request.iotInstanceId;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.productKey = request.productKey;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotId(String iotId) {
            this.putQueryParameter("IotId", iotId);
            this.iotId = iotId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public GetThingTopoRequest build() {
            return new GetThingTopoRequest(this);
        }
    }
}

