/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class ImportDTDataRequest
extends Request {
    @Body
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Body
    @NameInMap(value="Items")
    @Validation(required=true)
    private List<Items> items;
    @Body
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;

    private ImportDTDataRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.items = builder.items;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ImportDTDataRequest create() {
        return ImportDTDataRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public List<Items> getItems() {
        return this.items;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static class Items
    extends TeaModel {
        @NameInMap(value="DeviceName")
        @Validation(required=true)
        private String deviceName;
        @NameInMap(value="Params")
        @Validation(required=true)
        private String params;

        private Items(Builder builder) {
            this.deviceName = builder.deviceName;
            this.params = builder.params;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Items create() {
            return Items.builder().build();
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public String getParams() {
            return this.params;
        }

        public static final class Builder {
            private String deviceName;
            private String params;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder params(String params) {
                this.params = params;
                return this;
            }

            public Items build() {
                return new Items(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ImportDTDataRequest, Builder> {
        private String iotInstanceId;
        private List<Items> items;
        private String productKey;

        private Builder() {
        }

        private Builder(ImportDTDataRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.items = request.items;
            this.productKey = request.productKey;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putBodyParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder items(List<Items> items) {
            this.putBodyParameter("Items", items);
            this.items = items;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putBodyParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public ImportDTDataRequest build() {
            return new ImportDTDataRequest(this);
        }
    }
}

