/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class ListAnalyticsDataRequest
extends Request {
    @Query
    @NameInMap(value="ApiPath")
    @Validation(required=true)
    private String apiPath;
    @Query
    @NameInMap(value="Condition")
    private List<Condition> condition;
    @Query
    @NameInMap(value="IotInstanceId")
    @Validation(required=true)
    private String iotInstanceId;
    @Query
    @NameInMap(value="IsoId")
    private String isoId;
    @Query
    @NameInMap(value="PageNum")
    @Validation(maximum=1000.0, minimum=1.0)
    private Integer pageNum;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=20000.0, minimum=1.0)
    private Integer pageSize;

    private ListAnalyticsDataRequest(Builder builder) {
        super((Request.Builder)builder);
        this.apiPath = builder.apiPath;
        this.condition = builder.condition;
        this.iotInstanceId = builder.iotInstanceId;
        this.isoId = builder.isoId;
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListAnalyticsDataRequest create() {
        return ListAnalyticsDataRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public List<Condition> getCondition() {
        return this.condition;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getIsoId() {
        return this.isoId;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static class Condition
    extends TeaModel {
        @NameInMap(value="BetweenEnd")
        private String betweenEnd;
        @NameInMap(value="BetweenStart")
        private String betweenStart;
        @NameInMap(value="FieldName")
        @Validation(required=true)
        private String fieldName;
        @NameInMap(value="Operate")
        @Validation(required=true)
        private String operate;
        @NameInMap(value="Value")
        private String value;

        private Condition(Builder builder) {
            this.betweenEnd = builder.betweenEnd;
            this.betweenStart = builder.betweenStart;
            this.fieldName = builder.fieldName;
            this.operate = builder.operate;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Condition create() {
            return Condition.builder().build();
        }

        public String getBetweenEnd() {
            return this.betweenEnd;
        }

        public String getBetweenStart() {
            return this.betweenStart;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getOperate() {
            return this.operate;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String betweenEnd;
            private String betweenStart;
            private String fieldName;
            private String operate;
            private String value;

            public Builder betweenEnd(String betweenEnd) {
                this.betweenEnd = betweenEnd;
                return this;
            }

            public Builder betweenStart(String betweenStart) {
                this.betweenStart = betweenStart;
                return this;
            }

            public Builder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public Builder operate(String operate) {
                this.operate = operate;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Condition build() {
                return new Condition(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ListAnalyticsDataRequest, Builder> {
        private String apiPath;
        private List<Condition> condition;
        private String iotInstanceId;
        private String isoId;
        private Integer pageNum;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(ListAnalyticsDataRequest request) {
            super((Request)request);
            this.apiPath = request.apiPath;
            this.condition = request.condition;
            this.iotInstanceId = request.iotInstanceId;
            this.isoId = request.isoId;
            this.pageNum = request.pageNum;
            this.pageSize = request.pageSize;
        }

        public Builder apiPath(String apiPath) {
            this.putQueryParameter("ApiPath", apiPath);
            this.apiPath = apiPath;
            return this;
        }

        public Builder condition(List<Condition> condition) {
            this.putQueryParameter("Condition", condition);
            this.condition = condition;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder isoId(String isoId) {
            this.putQueryParameter("IsoId", isoId);
            this.isoId = isoId;
            return this;
        }

        public Builder pageNum(Integer pageNum) {
            this.putQueryParameter("PageNum", pageNum);
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public ListAnalyticsDataRequest build() {
            return new ListAnalyticsDataRequest(this);
        }
    }
}

