/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class ListDestinationRequest
extends Request {
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="Page")
    @Validation(required=true, maximum=9999999.0, minimum=1.0)
    private Integer page;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true, maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="SearchName")
    private String searchName;
    @Query
    @NameInMap(value="Types")
    private List<String> types;

    private ListDestinationRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.searchName = builder.searchName;
        this.types = builder.types;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListDestinationRequest create() {
        return ListDestinationRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public static final class Builder
    extends Request.Builder<ListDestinationRequest, Builder> {
        private String iotInstanceId;
        private Integer page;
        private Integer pageSize;
        private String searchName;
        private List<String> types;

        private Builder() {
        }

        private Builder(ListDestinationRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.page = request.page;
            this.pageSize = request.pageSize;
            this.searchName = request.searchName;
            this.types = request.types;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder page(Integer page) {
            this.putQueryParameter("Page", page);
            this.page = page;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder searchName(String searchName) {
            this.putQueryParameter("SearchName", searchName);
            this.searchName = searchName;
            return this;
        }

        public Builder types(List<String> types) {
            this.putQueryParameter("Types", types);
            this.types = types;
            return this;
        }

        public ListDestinationRequest build() {
            return new ListDestinationRequest(this);
        }
    }
}

