/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListDistributedDeviceRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    @Validation(required=true, minimum=1.0)
    private Integer currentPage;
    @Query
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true, maximum=200.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;
    @Query
    @NameInMap(value="SourceInstanceId")
    private String sourceInstanceId;
    @Query
    @NameInMap(value="TargetUid")
    private String targetUid;

    private ListDistributedDeviceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.deviceName = builder.deviceName;
        this.pageSize = builder.pageSize;
        this.productKey = builder.productKey;
        this.sourceInstanceId = builder.sourceInstanceId;
        this.targetUid = builder.targetUid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListDistributedDeviceRequest create() {
        return ListDistributedDeviceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getSourceInstanceId() {
        return this.sourceInstanceId;
    }

    public String getTargetUid() {
        return this.targetUid;
    }

    public static final class Builder
    extends Request.Builder<ListDistributedDeviceRequest, Builder> {
        private Integer currentPage;
        private String deviceName;
        private Integer pageSize;
        private String productKey;
        private String sourceInstanceId;
        private String targetUid;

        private Builder() {
        }

        private Builder(ListDistributedDeviceRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.deviceName = request.deviceName;
            this.pageSize = request.pageSize;
            this.productKey = request.productKey;
            this.sourceInstanceId = request.sourceInstanceId;
            this.targetUid = request.targetUid;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder sourceInstanceId(String sourceInstanceId) {
            this.putQueryParameter("SourceInstanceId", sourceInstanceId);
            this.sourceInstanceId = sourceInstanceId;
            return this;
        }

        public Builder targetUid(String targetUid) {
            this.putQueryParameter("TargetUid", targetUid);
            this.targetUid = targetUid;
            return this;
        }

        public ListDistributedDeviceRequest build() {
            return new ListDistributedDeviceRequest(this);
        }
    }
}

