/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class PubBroadcastRequest
extends Request {
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="MessageContent")
    @Validation(required=true)
    private String messageContent;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="TopicFullName")
    private String topicFullName;

    private PubBroadcastRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.messageContent = builder.messageContent;
        this.productKey = builder.productKey;
        this.topicFullName = builder.topicFullName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PubBroadcastRequest create() {
        return PubBroadcastRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getTopicFullName() {
        return this.topicFullName;
    }

    public static final class Builder
    extends Request.Builder<PubBroadcastRequest, Builder> {
        private String iotInstanceId;
        private String messageContent;
        private String productKey;
        private String topicFullName;

        private Builder() {
        }

        private Builder(PubBroadcastRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.messageContent = request.messageContent;
            this.productKey = request.productKey;
            this.topicFullName = request.topicFullName;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder messageContent(String messageContent) {
            this.putQueryParameter("MessageContent", messageContent);
            this.messageContent = messageContent;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder topicFullName(String topicFullName) {
            this.putQueryParameter("TopicFullName", topicFullName);
            this.topicFullName = topicFullName;
            return this;
        }

        public PubBroadcastRequest build() {
            return new PubBroadcastRequest(this);
        }
    }
}

