/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class PubRequest
extends Request {
    @Query
    @NameInMap(value="ContentType")
    private String contentType;
    @Query
    @NameInMap(value="CorrelationData")
    private String correlationData;
    @Query
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Body
    @NameInMap(value="MessageContent")
    @Validation(required=true)
    private String messageContent;
    @Query
    @NameInMap(value="PayloadFormatIndicator")
    private Integer payloadFormatIndicator;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="Qos")
    private Integer qos;
    @Query
    @NameInMap(value="ResponseTopic")
    private String responseTopic;
    @Query
    @NameInMap(value="TopicFullName")
    @Validation(required=true)
    private String topicFullName;
    @Query
    @NameInMap(value="UserProp")
    private List<UserProp> userProp;

    private PubRequest(Builder builder) {
        super((Request.Builder)builder);
        this.contentType = builder.contentType;
        this.correlationData = builder.correlationData;
        this.deviceName = builder.deviceName;
        this.iotInstanceId = builder.iotInstanceId;
        this.messageContent = builder.messageContent;
        this.payloadFormatIndicator = builder.payloadFormatIndicator;
        this.productKey = builder.productKey;
        this.qos = builder.qos;
        this.responseTopic = builder.responseTopic;
        this.topicFullName = builder.topicFullName;
        this.userProp = builder.userProp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PubRequest create() {
        return PubRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCorrelationData() {
        return this.correlationData;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public Integer getPayloadFormatIndicator() {
        return this.payloadFormatIndicator;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public Integer getQos() {
        return this.qos;
    }

    public String getResponseTopic() {
        return this.responseTopic;
    }

    public String getTopicFullName() {
        return this.topicFullName;
    }

    public List<UserProp> getUserProp() {
        return this.userProp;
    }

    public static class UserProp
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private UserProp(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static UserProp create() {
            return UserProp.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public UserProp build() {
                return new UserProp(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<PubRequest, Builder> {
        private String contentType;
        private String correlationData;
        private String deviceName;
        private String iotInstanceId;
        private String messageContent;
        private Integer payloadFormatIndicator;
        private String productKey;
        private Integer qos;
        private String responseTopic;
        private String topicFullName;
        private List<UserProp> userProp;

        private Builder() {
        }

        private Builder(PubRequest request) {
            super((Request)request);
            this.contentType = request.contentType;
            this.correlationData = request.correlationData;
            this.deviceName = request.deviceName;
            this.iotInstanceId = request.iotInstanceId;
            this.messageContent = request.messageContent;
            this.payloadFormatIndicator = request.payloadFormatIndicator;
            this.productKey = request.productKey;
            this.qos = request.qos;
            this.responseTopic = request.responseTopic;
            this.topicFullName = request.topicFullName;
            this.userProp = request.userProp;
        }

        public Builder contentType(String contentType) {
            this.putQueryParameter("ContentType", contentType);
            this.contentType = contentType;
            return this;
        }

        public Builder correlationData(String correlationData) {
            this.putQueryParameter("CorrelationData", correlationData);
            this.correlationData = correlationData;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder messageContent(String messageContent) {
            this.putBodyParameter("MessageContent", messageContent);
            this.messageContent = messageContent;
            return this;
        }

        public Builder payloadFormatIndicator(Integer payloadFormatIndicator) {
            this.putQueryParameter("PayloadFormatIndicator", payloadFormatIndicator);
            this.payloadFormatIndicator = payloadFormatIndicator;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder qos(Integer qos) {
            this.putQueryParameter("Qos", qos);
            this.qos = qos;
            return this;
        }

        public Builder responseTopic(String responseTopic) {
            this.putQueryParameter("ResponseTopic", responseTopic);
            this.responseTopic = responseTopic;
            return this;
        }

        public Builder topicFullName(String topicFullName) {
            this.putQueryParameter("TopicFullName", topicFullName);
            this.topicFullName = topicFullName;
            return this;
        }

        public Builder userProp(List<UserProp> userProp) {
            this.putQueryParameter("UserProp", userProp);
            this.userProp = userProp;
            return this;
        }

        public PubRequest build() {
            return new PubRequest(this);
        }
    }
}

