/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class PublishScriptRequest
extends Request {
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ParserId")
    @Validation(required=true, maximum=9.9999999E7)
    private Long parserId;

    private PublishScriptRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.parserId = builder.parserId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PublishScriptRequest create() {
        return PublishScriptRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Long getParserId() {
        return this.parserId;
    }

    public static final class Builder
    extends Request.Builder<PublishScriptRequest, Builder> {
        private String iotInstanceId;
        private Long parserId;

        private Builder() {
        }

        private Builder(PublishScriptRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.parserId = request.parserId;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder parserId(Long parserId) {
            this.putQueryParameter("ParserId", parserId);
            this.parserId = parserId;
            return this;
        }

        public PublishScriptRequest build() {
            return new PublishScriptRequest(this);
        }
    }
}

