/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryDeviceFileListRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    private Integer currentPage;
    @Query
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="IotId")
    private String iotId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;

    private QueryDeviceFileListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.deviceName = builder.deviceName;
        this.iotId = builder.iotId;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageSize = builder.pageSize;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryDeviceFileListRequest create() {
        return QueryDeviceFileListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIotId() {
        return this.iotId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static final class Builder
    extends Request.Builder<QueryDeviceFileListRequest, Builder> {
        private Integer currentPage;
        private String deviceName;
        private String iotId;
        private String iotInstanceId;
        private Integer pageSize;
        private String productKey;

        private Builder() {
        }

        private Builder(QueryDeviceFileListRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.deviceName = request.deviceName;
            this.iotId = request.iotId;
            this.iotInstanceId = request.iotInstanceId;
            this.pageSize = request.pageSize;
            this.productKey = request.productKey;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotId(String iotId) {
            this.putQueryParameter("IotId", iotId);
            this.iotId = iotId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public QueryDeviceFileListRequest build() {
            return new QueryDeviceFileListRequest(this);
        }
    }
}

