/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryDeviceFileRequest
extends Request {
    @Query
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="FileId")
    @Validation(required=true)
    private String fileId;
    @Query
    @NameInMap(value="IotId")
    private String iotId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;

    private QueryDeviceFileRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.fileId = builder.fileId;
        this.iotId = builder.iotId;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryDeviceFileRequest create() {
        return QueryDeviceFileRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getIotId() {
        return this.iotId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static final class Builder
    extends Request.Builder<QueryDeviceFileRequest, Builder> {
        private String deviceName;
        private String fileId;
        private String iotId;
        private String iotInstanceId;
        private String productKey;

        private Builder() {
        }

        private Builder(QueryDeviceFileRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.fileId = request.fileId;
            this.iotId = request.iotId;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder fileId(String fileId) {
            this.putQueryParameter("FileId", fileId);
            this.fileId = fileId;
            return this;
        }

        public Builder iotId(String iotId) {
            this.putQueryParameter("IotId", iotId);
            this.iotId = iotId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public QueryDeviceFileRequest build() {
            return new QueryDeviceFileRequest(this);
        }
    }
}

