/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryEdgeDriverVersionRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    @Validation(required=true)
    private Integer currentPage;
    @Query
    @NameInMap(value="DriverId")
    @Validation(required=true)
    private String driverId;
    @Query
    @NameInMap(value="DriverVersion")
    private String driverVersion;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true)
    private Integer pageSize;
    @Query
    @NameInMap(value="VersionState")
    private Integer versionState;

    private QueryEdgeDriverVersionRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.driverId = builder.driverId;
        this.driverVersion = builder.driverVersion;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageSize = builder.pageSize;
        this.versionState = builder.versionState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryEdgeDriverVersionRequest create() {
        return QueryEdgeDriverVersionRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getDriverId() {
        return this.driverId;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getVersionState() {
        return this.versionState;
    }

    public static final class Builder
    extends Request.Builder<QueryEdgeDriverVersionRequest, Builder> {
        private Integer currentPage;
        private String driverId;
        private String driverVersion;
        private String iotInstanceId;
        private Integer pageSize;
        private Integer versionState;

        private Builder() {
        }

        private Builder(QueryEdgeDriverVersionRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.driverId = request.driverId;
            this.driverVersion = request.driverVersion;
            this.iotInstanceId = request.iotInstanceId;
            this.pageSize = request.pageSize;
            this.versionState = request.versionState;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder driverId(String driverId) {
            this.putQueryParameter("DriverId", driverId);
            this.driverId = driverId;
            return this;
        }

        public Builder driverVersion(String driverVersion) {
            this.putQueryParameter("DriverVersion", driverVersion);
            this.driverVersion = driverVersion;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder versionState(Integer versionState) {
            this.putQueryParameter("VersionState", versionState);
            this.versionState = versionState;
            return this;
        }

        public QueryEdgeDriverVersionRequest build() {
            return new QueryEdgeDriverVersionRequest(this);
        }
    }
}

