/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryEdgeInstanceRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    @Validation(required=true)
    private Integer currentPage;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true)
    private Integer pageSize;

    private QueryEdgeInstanceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.iotInstanceId = builder.iotInstanceId;
        this.name = builder.name;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryEdgeInstanceRequest create() {
        return QueryEdgeInstanceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<QueryEdgeInstanceRequest, Builder> {
        private Integer currentPage;
        private String iotInstanceId;
        private String name;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(QueryEdgeInstanceRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.iotInstanceId = request.iotInstanceId;
            this.name = request.name;
            this.pageSize = request.pageSize;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public QueryEdgeInstanceRequest build() {
            return new QueryEdgeInstanceRequest(this);
        }
    }
}

