/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryProductListRequest
extends Request {
    @Query
    @NameInMap(value="AliyunCommodityCode")
    private String aliyunCommodityCode;
    @Query
    @NameInMap(value="CurrentPage")
    @Validation(required=true)
    private Integer currentPage;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true)
    private Integer pageSize;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;

    private QueryProductListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.aliyunCommodityCode = builder.aliyunCommodityCode;
        this.currentPage = builder.currentPage;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageSize = builder.pageSize;
        this.resourceGroupId = builder.resourceGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryProductListRequest create() {
        return QueryProductListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAliyunCommodityCode() {
        return this.aliyunCommodityCode;
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public static final class Builder
    extends Request.Builder<QueryProductListRequest, Builder> {
        private String aliyunCommodityCode;
        private Integer currentPage;
        private String iotInstanceId;
        private Integer pageSize;
        private String resourceGroupId;

        private Builder() {
        }

        private Builder(QueryProductListRequest request) {
            super((Request)request);
            this.aliyunCommodityCode = request.aliyunCommodityCode;
            this.currentPage = request.currentPage;
            this.iotInstanceId = request.iotInstanceId;
            this.pageSize = request.pageSize;
            this.resourceGroupId = request.resourceGroupId;
        }

        public Builder aliyunCommodityCode(String aliyunCommodityCode) {
            this.putQueryParameter("AliyunCommodityCode", aliyunCommodityCode);
            this.aliyunCommodityCode = aliyunCommodityCode;
            return this;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public QueryProductListRequest build() {
            return new QueryProductListRequest(this);
        }
    }
}

