/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QuerySpeechListRequest
extends Request {
    @Body
    @NameInMap(value="AudioFormat")
    private String audioFormat;
    @Body
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Body
    @NameInMap(value="PageId")
    @Validation(maximum=10000.0, minimum=1.0)
    private Integer pageId;
    @Body
    @NameInMap(value="PageSize")
    @Validation(maximum=50.0, minimum=1.0)
    private Integer pageSize;
    @Body
    @NameInMap(value="ProjectCode")
    @Validation(required=true)
    private String projectCode;

    private QuerySpeechListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.audioFormat = builder.audioFormat;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageId = builder.pageId;
        this.pageSize = builder.pageSize;
        this.projectCode = builder.projectCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QuerySpeechListRequest create() {
        return QuerySpeechListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAudioFormat() {
        return this.audioFormat;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageId() {
        return this.pageId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public static final class Builder
    extends Request.Builder<QuerySpeechListRequest, Builder> {
        private String audioFormat;
        private String iotInstanceId;
        private Integer pageId;
        private Integer pageSize;
        private String projectCode;

        private Builder() {
        }

        private Builder(QuerySpeechListRequest request) {
            super((Request)request);
            this.audioFormat = request.audioFormat;
            this.iotInstanceId = request.iotInstanceId;
            this.pageId = request.pageId;
            this.pageSize = request.pageSize;
            this.projectCode = request.projectCode;
        }

        public Builder audioFormat(String audioFormat) {
            this.putBodyParameter("AudioFormat", audioFormat);
            this.audioFormat = audioFormat;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putBodyParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageId(Integer pageId) {
            this.putBodyParameter("PageId", pageId);
            this.pageId = pageId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putBodyParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder projectCode(String projectCode) {
            this.putBodyParameter("ProjectCode", projectCode);
            this.projectCode = projectCode;
            return this;
        }

        public QuerySpeechListRequest build() {
            return new QuerySpeechListRequest(this);
        }
    }
}

