/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryThingModelExtendConfigRequest
extends Request {
    @Query
    @NameInMap(value="FunctionBlockId")
    private String functionBlockId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ModelVersion")
    private String modelVersion;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;

    private QueryThingModelExtendConfigRequest(Builder builder) {
        super((Request.Builder)builder);
        this.functionBlockId = builder.functionBlockId;
        this.iotInstanceId = builder.iotInstanceId;
        this.modelVersion = builder.modelVersion;
        this.productKey = builder.productKey;
        this.resourceGroupId = builder.resourceGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryThingModelExtendConfigRequest create() {
        return QueryThingModelExtendConfigRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getFunctionBlockId() {
        return this.functionBlockId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public static final class Builder
    extends Request.Builder<QueryThingModelExtendConfigRequest, Builder> {
        private String functionBlockId;
        private String iotInstanceId;
        private String modelVersion;
        private String productKey;
        private String resourceGroupId;

        private Builder() {
        }

        private Builder(QueryThingModelExtendConfigRequest request) {
            super((Request)request);
            this.functionBlockId = request.functionBlockId;
            this.iotInstanceId = request.iotInstanceId;
            this.modelVersion = request.modelVersion;
            this.productKey = request.productKey;
            this.resourceGroupId = request.resourceGroupId;
        }

        public Builder functionBlockId(String functionBlockId) {
            this.putQueryParameter("FunctionBlockId", functionBlockId);
            this.functionBlockId = functionBlockId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.putQueryParameter("ModelVersion", modelVersion);
            this.modelVersion = modelVersion;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public QueryThingModelExtendConfigRequest build() {
            return new QueryThingModelExtendConfigRequest(this);
        }
    }
}

